/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.enabling.resultset.TypedResultSetListener;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.jaxb.JaxbFactory;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JaxbResultsetListenerWrapper<T> {
    private static final Log log = LogFactory.getLog(JaxbResultsetListenerWrapper.class);
    private JaxbFactory<T> factory;

    public ResultSetListener wrap(final TypedResultSetListener<T> listener) {
        return new ResultSetListener(){

            @Override
            public List<String> getResult(int fromPosition, int toPosition) {
                return Lists.newArrayList((Iterable)new MappedCollection(listener.getResult(fromPosition, toPosition), new UnaryFunction<String, T>(){

                    public String evaluate(T value) {
                        try {
                            return JaxbResultsetListenerWrapper.this.factory.serialize(value);
                        }
                        catch (JAXBException e) {
                            log.warn((Object)"cannot serialize", (Throwable)e);
                            throw new RuntimeException(e);
                        }
                    }
                }));
            }

            @Override
            public int getSize() {
                return listener.getSize();
            }
        };
    }

    public JaxbFactory<T> getFactory() {
        return this.factory;
    }

    public void setFactory(JaxbFactory<T> factory) {
        this.factory = factory;
    }
}

