/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.resultset.AbstractObservableResultset;
import eu.dnetlib.enabling.resultset.ResultSet;
import eu.dnetlib.enabling.resultset.ResultSetAware;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import java.util.List;

public class LocalResultSetImpl
extends AbstractObservableResultset
implements ResultSet {
    private String identifier;
    private ResultSetListener listener;

    public LocalResultSetImpl(ResultSetListener listener) {
        this.listener = listener;
        if (listener instanceof ResultSetAware) {
            ((ResultSetAware)((Object)listener)).setResultSet(this);
        }
    }

    @Override
    public int getNumberOfResults() {
        return this.listener.getSize();
    }

    @Override
    public List<String> getResults(int fromPosition, int toPosition) {
        int toPos = toPosition;
        int fromPos = fromPosition;
        if (!this.isOpen()) {
            int size = this.getNumberOfResults();
            if (size == 0) {
                return Lists.newArrayList();
            }
            if (fromPos > size) {
                return Lists.newArrayList();
            }
            if (toPos > size) {
                toPos = size;
            }
        }
        if (fromPos < 1) {
            fromPos = 1;
        }
        if (toPos < fromPos) {
            toPos = fromPos;
        }
        return this.listener.getResult(fromPos, toPos);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public ResultSetListener getListener() {
        return this.listener;
    }

    public void setListener(ResultSetListener listener) {
        this.listener = listener;
    }
}

