/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset;

import eu.dnetlib.enabling.resultset.ResultSet;
import eu.dnetlib.enabling.resultset.ResultSetRegistry;
import eu.dnetlib.enabling.tools.UniqueIdentifierGenerator;
import eu.dnetlib.enabling.tools.UniqueIdentifierGeneratorImpl;
import eu.dnetlib.miscutils.cache.Cache;
import org.springframework.beans.factory.annotation.Required;

public class ResultSetRegistryImpl
implements ResultSetRegistry {
    private Cache<String, ResultSet> cache;
    private Cache<String, Integer> maxIdleTimeCache;
    private UniqueIdentifierGenerator idGenerator = new UniqueIdentifierGeneratorImpl("rs-");

    @Override
    public void addResultSet(ResultSet resultSet) {
        this.addResultSet(resultSet, 0);
    }

    @Override
    public void addResultSet(ResultSet resultSet, String identifier) {
        this.addResultSet(resultSet, identifier, 0);
    }

    @Override
    public void addResultSet(ResultSet resultSet, int maxIdleTime) {
        this.addResultSet(resultSet, this.idGenerator.generateIdentifier(), maxIdleTime);
    }

    @Override
    public void addResultSet(ResultSet resultSet, String identifier, int maxIdleTime) {
        resultSet.setIdentifier(identifier);
        resultSet.addObserver(this);
        this.cache.put((Object)resultSet.getIdentifier(), (Object)resultSet);
        this.maxIdleTimeCache.put((Object)resultSet.getIdentifier(), (Object)maxIdleTime);
    }

    @Override
    public ResultSet getResultSetById(String rsId) {
        return (ResultSet)this.cache.get((Object)rsId);
    }

    @Override
    public int getMaxIdleTimeById(String rsId) {
        return (Integer)this.maxIdleTimeCache.get((Object)rsId);
    }

    public Cache<String, ResultSet> getCache() {
        return this.cache;
    }

    @Required
    public void setCache(Cache<String, ResultSet> cache) {
        this.cache = cache;
    }

    @Override
    public void update(ResultSet observed, Object arg) {
        if (!observed.isOpen()) {
            this.cache.remove((Object)observed.getIdentifier());
        }
    }

    public UniqueIdentifierGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(UniqueIdentifierGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public Cache<String, Integer> getMaxIdleTimeCache() {
        return this.maxIdleTimeCache;
    }

    @Required
    public void setMaxIdleTimeCache(Cache<String, Integer> maxIdleTimeCache) {
        this.maxIdleTimeCache = maxIdleTimeCache;
    }
}

