/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.resultset.MappedResultSet;
import eu.dnetlib.enabling.tools.ServiceResolver;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

public class ParallelMappedResultSet
extends MappedResultSet {
    private ExecutorService executor;

    public ParallelMappedResultSet(W3CEndpointReference source, UnaryFunction<String, String> mapper, ServiceResolver serviceResolver, ExecutorService executor) {
        super(source, mapper, serviceResolver);
        this.executor = executor;
    }

    @Override
    public List<String> getResult(int fromPosition, int toPosition) {
        ArrayList results = Lists.newArrayList();
        for (final String input : this.getResultFromSource(fromPosition, toPosition)) {
            results.add(this.executor.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return (String)ParallelMappedResultSet.this.getMapper().evaluate((Object)input);
                }
            }));
        }
        return MappedCollection.listMap((Iterable)results, (UnaryFunction)new UnaryFunction<String, Future<String>>(){

            public String evaluate(Future<String> arg) {
                try {
                    return arg.get();
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
                catch (ExecutionException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }
}

