/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset;

import eu.dnetlib.enabling.resultset.MappedResultSetFactory;
import eu.dnetlib.enabling.resultset.ParallelMappedResultSet;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

public class ParallelMappedResultSetFactory
extends MappedResultSetFactory {
    private ExecutorService executor;
    private static final int QUEUE_SIZE = 40;
    private int queueSize = 40;
    private int cpus = 0;

    public ParallelMappedResultSetFactory() {
        if (this.cpus == 0) {
            this.cpus = this.getNumberOfCPUs();
        }
        this.executor = new ThreadPoolExecutor(this.cpus, this.cpus, 5L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.queueSize), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Override
    public W3CEndpointReference createMappedResultSet(W3CEndpointReference source, UnaryFunction<String, String> mapper) {
        return this.getResultSetFactory().createResultSet(new ParallelMappedResultSet(source, mapper, this.getServiceResolver(), this.executor));
    }

    private int getNumberOfCPUs() {
        return Runtime.getRuntime().availableProcessors();
    }

    public int getCpus() {
        return this.cpus;
    }

    public void setCpus(int cpus) {
        if (cpus > 0) {
            this.cpus = cpus;
        }
    }
}

