/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset;

import eu.dnetlib.common.rmi.UnimplementedException;
import eu.dnetlib.enabling.resultset.ResultSet;
import eu.dnetlib.enabling.resultset.ResultSetPropertyDao;
import eu.dnetlib.enabling.resultset.ResultSetRegistry;
import eu.dnetlib.enabling.resultset.push.PushResultSet;
import eu.dnetlib.enabling.resultset.push.PushResultSetFactory;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.soap.EndpointReferenceBuilder;
import java.util.List;
import javax.xml.ws.Endpoint;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class ResultSetServiceImpl
extends AbstractBaseService
implements ResultSetService {
    private static final Log log = LogFactory.getLog(ResultSetServiceImpl.class);
    private ResultSetRegistry resultsetRegistry;
    private PushResultSetFactory pushFactory;
    private Endpoint endpoint;
    private EndpointReferenceBuilder<Endpoint> eprBuilder;
    private ResultSetPropertyDao customPropertyDao;

    public void closeRS(String rsId) {
        try {
            ResultSet resultSet = this.getResultSetById(rsId);
            resultSet.close();
        }
        catch (ResultSetException e) {
            log.warn((Object)"should throw checked exception but wasn't declared in cnr-rmi-api", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public W3CEndpointReference createPullRS(String providerAddress, String bdId, int initialPageSize, int expiryTime, String styleSheet, Integer keepAliveTime, Integer total) {
        throw new UnimplementedException();
    }

    public W3CEndpointReference createPullRSEPR(W3CEndpointReference dataProviderEPR, String bdId, int initialPageSize, int expiryTime, String styleSheet, Integer keepAliveTime, Integer total) {
        throw new UnimplementedException();
    }

    public int getNumberOfElements(String rsId) throws ResultSetException {
        ResultSet resultSet = this.getResultSetById(rsId);
        return resultSet.getNumberOfResults();
    }

    public List<String> getResult(String rsId, int fromPosition, int toPosition, String requestMode) throws ResultSetException {
        ResultSet resultSet = this.getResultSetById(rsId);
        return resultSet.getResults(fromPosition, toPosition);
    }

    public W3CEndpointReference createPushRS(int expiryTime, int keepAliveTime) throws ResultSetException {
        return this.pushFactory.createPushResultSet(expiryTime);
    }

    public String getProperty(String rsId, String name) throws ResultSetException {
        ResultSet resultSet = this.getResultSetById(rsId);
        if ("rsId".equals(name)) {
            return resultSet.getIdentifier();
        }
        if ("total".equals(name)) {
            return Integer.toString(resultSet.getNumberOfResults());
        }
        if ("maxExpiryTime".equals(name)) {
            return Integer.toString(this.resultsetRegistry.getMaxIdleTimeById(rsId));
        }
        if ("expiryTime".equals(name)) {
            return Integer.toString(this.resultsetRegistry.getMaxIdleTimeById(rsId));
        }
        if ("keepAliveTime".equals(name)) {
            return Integer.toString(this.resultsetRegistry.getMaxIdleTimeById(rsId));
        }
        return this.customPropertyDao.getProperties(resultSet).get(name);
    }

    public String getRSStatus(String rsId) throws ResultSetException {
        ResultSet resultSet = this.getResultSetById(rsId);
        if (resultSet.isOpen()) {
            return "open";
        }
        return "closed";
    }

    public String populateRS(String rsId, List<String> elements) throws ResultSetException {
        ResultSet resultSet = this.getResultSetById(rsId);
        if (!(resultSet instanceof PushResultSet)) {
            throw new ResultSetException("ResultSet '" + rsId + "' is not a push resultset");
        }
        ((PushResultSet)resultSet).addElements(elements);
        return "1";
    }

    public void start() {
    }

    private ResultSet getResultSetById(String rsId) throws ResultSetException {
        ResultSet resultSet = this.resultsetRegistry.getResultSetById(rsId);
        if (resultSet == null) {
            throw new ResultSetException("resultset with id '" + rsId + "' doesn't exist");
        }
        return resultSet;
    }

    public ResultSetRegistry getResultsetRegistry() {
        return this.resultsetRegistry;
    }

    @Required
    public void setResultsetRegistry(ResultSetRegistry resultsetRegistry) {
        this.resultsetRegistry = resultsetRegistry;
    }

    public EndpointReferenceBuilder<Endpoint> getEprBuilder() {
        return this.eprBuilder;
    }

    @Required
    public void setEprBuilder(EndpointReferenceBuilder<Endpoint> eprBuilder) {
        this.eprBuilder = eprBuilder;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Required
    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public PushResultSetFactory getPushFactory() {
        return this.pushFactory;
    }

    @Required
    public void setPushFactory(PushResultSetFactory pushFactory) {
        this.pushFactory = pushFactory;
    }

    public ResultSetPropertyDao getCustomPropertyDao() {
        return this.customPropertyDao;
    }

    public void setCustomPropertyDao(ResultSetPropertyDao customPropertyDao) {
        this.customPropertyDao = customPropertyDao;
    }
}

