<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	exclude-result-prefixes="xsl dr dc">

	<xsl:output method="html" version="1.0" encoding="UTF-8"
		indent="yes" />

	<xsl:template match="/">
		<table>
			<tr>
				<td>
					<img src="static.get?src=doc.png" width="80" height="80" />
				</td>
				<td>
					<b>Entity type: </b><xsl:value-of select="//*[local-name()='entityType']" />
					<br/>	
					<b>Title: </b><xsl:value-of select="//*[local-name()='title']" />
					<xsl:variable name="url" select="//url" />
					<br/>			
					<b>Description: </b><i><xsl:value-of select="//*[local-name()='description']" /></i>
					<br />
					<br />
					<xsl:if test="$url">
						<br/>
						<b>Image at: </b>
						<a>
							<xsl:attribute name="href"><xsl:value-of
								select="$url" /></xsl:attribute>
							<xsl:value-of select="$url" />
						</a>
					</xsl:if>
				</td>
			</tr>
		</table>
	</xsl:template>

</xsl:stylesheet>
