<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:dc="http://purl.org/dc/elements/1.1/">

	<xsl:output method="html" version="1.0" encoding="UTF-8"
		indent="yes" />

	<xsl:template match="/">
		<xsl:if test="//*[local-name()='title']">
			<b>Title: </b>
			<xsl:value-of select="//*[local-name()='title']" />
			<br />
		</xsl:if>

		<xsl:if test="//*[local-name()='description']">
			<b>Description: </b>
			<xsl:value-of select="//*[local-name()='description']" />
			<br />
		</xsl:if>

		<xsl:if test="//*[local-name()='providerName']">
			<b>Provided by: </b>
			<xsl:value-of select="//*[local-name()='providerName']" />
			<br />
		</xsl:if>

		<xsl:if test="//*[local-name()='dateEdited']">
			<b>Last edit: </b>
			<xsl:value-of select="//*[local-name()='dateEdited']" />
			<br />
		</xsl:if>

		<xsl:if test="//*[local-name()='metadataEditor']">
			<b>Metadata edited by: </b>
			<xsl:value-of select="//*[local-name()='metadataEditor']" />
			<br />
		</xsl:if>

		<xsl:if test="//*[local-name()='dateOfCollection']">
			<b>Collected on: </b>
			<xsl:value-of select="//*[local-name()='dateOfCollection']" />
			<br />
		</xsl:if>
		
		<fieldset>
			<legend>Relationships</legend>
		
			<xsl:if test="//*[local-name()='hasTranscription']">
				<b>Has transcription: </b>
				<xsl:variable name="linkrel" select="//*[local-name()='hasTranscription']" />
				<a href="documentCQL.do?key=dnetresourceidentifier&amp;value={$linkrel}"><xsl:value-of select="$linkrel" /></a>
				<br/>
			</xsl:if>
			
			<xsl:for-each select="//*[local-name()='hasInscriptionVisualRepresentation']">
	
				<b>Has visual representation: </b>
				<xsl:variable name="linkrel" select="." />
				<a href="documentCQL.do?key=dnetresourceidentifier&amp;value={$linkrel}"><xsl:value-of select="$linkrel" /></a>
				<br/>
			</xsl:for-each>
			
			<xsl:if test="//*[local-name()='isTranscriptionOf']">
				<b>Is transcription of: </b>
				<xsl:variable name="linkrel" select="//*[local-name()='isTranscriptionOf']" />
				<a href="documentCQL.do?key=dnetresourceidentifier&amp;value={$linkrel}"><xsl:value-of select="$linkrel" /></a>
			</xsl:if>
			
			<xsl:if test="//*[local-name()='isRepresentationOf']">
				<b>Is representation of: </b>
				<xsl:variable name="linkrel" select="//*[local-name()='isRepresentationOf']" />
				<a href="documentCQL.do?key=dnetresourceidentifier&amp;value={$linkrel}"><xsl:value-of select="$linkrel" /></a>
			</xsl:if>
		</fieldset>
		
		<xsl:variable name="url" select="//*[local-name()='url']" />
		<xsl:if test="$url">
			<br/>
				<img src="{$url}" width="20%" />
			<br/>
		</xsl:if>

		<br/>
		<xsl:for-each select="//*[local-name()='eagleObject']">
			<fieldset>
				<legend>Record XML</legend>
				<xsl:call-template name="xmlItem">
					<xsl:with-param name="indent" select="string('')" />
				</xsl:call-template>
			</fieldset>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="xmlItem">
		<xsl:param name="indent" />


		<xsl:variable name="tag" select="local-name()" />

		<xsl:variable name="newindent">
			<xsl:value-of select="$indent" />
			&#160;&#160;&#160;&#160;
		</xsl:variable>

		<xsl:variable name="attribs">
			<xsl:for-each select="@*">
				<xsl:value-of select="concat(' ', local-name(), '=&quot;', ., '&quot;')" />
			</xsl:for-each>
		</xsl:variable>
		<xsl:value-of select="$indent" />

		<b>
			<xsl:value-of select="concat('&lt;eagle:',$tag)" />
		</b>
		<i>
			<xsl:value-of select="$attribs" />
		</i>
		<b>&gt;</b>

		<xsl:value-of select="text()" />

		<xsl:choose>
			<xsl:when test="count(child::*) &gt; 0">
				<br />
				<xsl:for-each select="child::*">
					<xsl:call-template name="xmlItem">
						<xsl:with-param name="indent" select="$newindent" />
					</xsl:call-template>
					<br />
				</xsl:for-each>
				<xsl:value-of select="$indent" />
			</xsl:when>
			<xsl:otherwise>

			</xsl:otherwise>
		</xsl:choose>

		<b>
			<xsl:value-of select="concat('&lt;/eagle:',$tag,'&gt;')" />
		</b>

	</xsl:template>


</xsl:stylesheet>
