<NODE name="SET_INFO" isStart="true" type="SetEagleInfo">
	<DESCRIPTION>Retrieve information about current Content Provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="fetchOriginals"/>
	</ARCS>
</NODE>

<NODE name="fetchOriginals" type="FetchMDStoreRecords">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("coll_id")$</PARAM>
		<PARAM required="true" type="string" name="mdFormat" managedBy="system">$params.("coll_format")$</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">orig_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="populateVocabularies"/>
	</ARCS>
</NODE>

<NODE name="populateVocabularies" type="ApplyXslt">
	<DESCRIPTION>Populate with Tematres vocabularies</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">orig_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">voc_epr</PARAM>
		<PARAM required="true" type="string" name="xsltClasspath" managedBy="user">/eu/dnetlib/msro/eagle/vocabularies/popWithVoc.xsl</PARAM>
		<PARAM required="true" type="string" name="envParams" managedBy="system">
			{
				"CP_ACRONYM" : "dataprovider:acronym",
				"CP_URL" : "dataprovider:url",
				"CP_NAME" : "dataprovider:name"
			}
		</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="storeRecords"/>
	</ARCS>
</NODE>

<NODE name="storeRecords" type="StoreMDStoreRecords">
	<DESCRIPTION>Store records into mdstore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("coll_id")$</PARAM>
		<PARAM required="true" type="string" name="storingType" managedBy="user">REFRESH</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">voc_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>