<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dnet="eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions"
	xmlns:utils="eu.dnetlib.miscutils.datetime.DateUtils" xmlns:tei="http://www.tei-c.org/ns/1.0"
	xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:eagle="http://www.eagle-network.eu/eagle"
	exclude-result-prefixes="xsl tei dnet utils">

	<xsl:output indent="yes" />

	<xsl:param name="CP_ACRONYM" />
	<xsl:param name="CP_URL" />
	<xsl:param name="CP_NAME" />

	<xsl:variable name="REPO_ID" select="//dri:repositoryId" />
	<xsl:variable name="ORIG_OBJ_ID" select="//dri:objIdentifier" />

	<xsl:variable name="NOW" select="utils:now_ISO8601()" />

	<xsl:variable name="LANG" select="//tei:TEI/@*[local-name()='lang']" />
	<xsl:variable name="LOCAL_ID" select="//tei:idno" />
	<xsl:variable name="LOCAL_ID_MD5" select="dnet:md5(//tei:idno)" />
	<xsl:variable name="DATE_EDITED" select="//tei:change/@when" />
	<xsl:variable name="METADATA_EDITOR" select="//tei:change/@who" />
	<xsl:variable name="IPR_URL" select="//tei:licence/@target" />
	<xsl:variable name="IPR_STATEMENT" select="//tei:licence" />
	<xsl:variable name="TITLE" select="//tei:titleStmt/tei:title" />
	<xsl:variable name="DESCRIPTION" select="//tei:titleStmt/tei:title" />

	<xsl:template name="commonProperties">
		<recordSourceInfo>
			<xsl:attribute name="providerName">
                <xsl:value-of select="$CP_NAME" />
            </xsl:attribute>
			<xsl:attribute name="providerAcronym">
                <xsl:value-of select="$CP_ACRONYM" />
            </xsl:attribute>
			<xsl:attribute name="providerURI">
                <xsl:value-of select="$CP_URL" />
            </xsl:attribute>
			<xsl:value-of select="$LOCAL_ID" />
		</recordSourceInfo>
		<editingInfo>
			<dateEdited>
				<xsl:value-of select="$DATE_EDITED" />
			</dateEdited>
			<metadataEditor>
				<xsl:value-of select="$METADATA_EDITOR" />
			</metadataEditor>
		</editingInfo>
		<metadataIpr>
			<xsl:attribute name="url">
                <xsl:value-of select="$IPR_URL" />
            </xsl:attribute>
			<xsl:value-of select="$IPR_STATEMENT" />
		</metadataIpr>
		<title>
			<xsl:attribute name="lang">
                <xsl:value-of select="$LANG" />
            </xsl:attribute>
			<xsl:value-of select="$TITLE" />
		</title>
		<description>
			<xsl:attribute name="lang">
                <xsl:value-of select="$LANG" />
            </xsl:attribute>
			<xsl:value-of select="$DESCRIPTION" />
		</description>
	</xsl:template>

	<xsl:template match="/">
		<package>
			<!-- ARTIFACT -->
			<record>
				<header>
					<dri:objIdentifier>
						<xsl:value-of select="concat($ORIG_OBJ_ID, '_artifact')" />
					</dri:objIdentifier>
					<dri:dateOfCollection>
						<xsl:value-of select="$NOW" />
					</dri:dateOfCollection>
					<dri:repositoryId>
						<xsl:value-of select="$REPO_ID" />
					</dri:repositoryId>
				</header>
				<metadata>
					<eagleObject>
						<dnetResourceIdentifier>
							<xsl:value-of select="concat('artifact::', $CP_ACRONYM, '::', $LOCAL_ID_MD5)" />
						</dnetResourceIdentifier>
						<xsl:call-template name="commonProperties" />
						<entityType>Artifact</entityType>
						<artifact>
							<artifactType>Inscription</artifactType>
							<monumentType>
								<xsl:attribute name="uri">
                                    <xsl:value-of select="//tei:objectType/@ref" />
                                </xsl:attribute>
								<xsl:value-of select="//*[local-name()='objectType']" />
							</monumentType>
							<material>
								<xsl:attribute name="uri">
                                    <xsl:value-of select="//tei:material/@ref" />
                                </xsl:attribute>
								<xsl:value-of select="//*[local-name()='material']" />
							</material>
							<dimensions>
								<xsl:attribute name="unit">
                                    <xsl:value-of select="//tei:support/tei:dimensions/@unit" />
                                </xsl:attribute>
								<width>
									<xsl:value-of select="//tei:support/tei:dimensions/tei:width" />
								</width>
								<height>
									<xsl:value-of select="//tei:support/tei:dimensions/tei:height" />
								</height>
								<depth>
									<xsl:value-of select="//tei:support/tei:dimensions/tei:depth" />
								</depth>
							</dimensions>
							<decoration>
								<xsl:attribute name="uri">
                                    <xsl:value-of select="//tei:support/tei:rs[@type='decoration']/@ref" />
                                </xsl:attribute>
								<xsl:value-of select="//tei:support/tei:rs[@type='decoration']" />
							</decoration>
							<stateOfPreservation>
								<xsl:attribute name="uri">
                                    <xsl:value-of select="//tei:support/tei:rs[@type='statPreserv']/@ref" />
                                </xsl:attribute>
								<xsl:value-of select="//tei:support/tei:rs[@type='statPreserv']" />
							</stateOfPreservation>
							<originDating>
								<xsl:attribute name="notBefore"><xsl:value-of select="//tei:origDate/@notBefore-custom" /></xsl:attribute>
								<xsl:attribute name="notAfter"><xsl:value-of select="//tei:origDate/@notAfter-custom" /></xsl:attribute>
								<xsl:attribute name="datingMethod"><xsl:value-of select="//tei:origDate/@datingMethod" /></xsl:attribute>
								<xsl:attribute name="evidence"><xsl:value-of select="//tei:origDate/@evidence" /></xsl:attribute>
								<xsl:attribute name="period"><xsl:value-of select="//tei:origDate/@period" /></xsl:attribute>
								<xsl:value-of select="//tei:origDate" />
							</originDating>
							<yearOfFinding>
								<xsl:value-of select="//tei:provenance/tei:date/@when" />
							</yearOfFinding>
							<findingSpot>
								<romanProvinceItalicRegion>
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//tei:origPlace/tei:placeName[@type='provinceItalicRegion']/@ref" />
                                    </xsl:attribute>
									<xsl:value-of select="//tei:origPlace/tei:placeName[@type='provinceItalicRegion']" />
								</romanProvinceItalicRegion>
								<ancientFindSpot>
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//tei:origPlace/tei:placeName[not(@type)]/@ref" />
                                    </xsl:attribute>
									<xsl:value-of select="//tei:origPlace/tei:placeName[not(@type)]" />
								</ancientFindSpot>
								<modernFindSpot>
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//tei:provenance[@type='found']/tei:placeName[not(@type)]/@ref" />
                                    </xsl:attribute>
									<xsl:value-of select="//tei:provenance[@type='found']/tei:placeName[not(@type)]" />
								</modernFindSpot>
								<modernCountry>
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//tei:provenance[@type='found']/tei:placeName[@type='modernCountry']/@ref" />
                                    </xsl:attribute>
									<xsl:value-of select="//tei:provenance[@type='found']/tei:placeName[@type='modernCountry']" />
								</modernCountry>
								<modernRegion>
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//tei:provenance[@type='found']/tei:placeName[@type='modernRegion']/@ref" />
                                    </xsl:attribute>
									<xsl:value-of select="//tei:provenance[@type='found']/tei:placeName[@type='modernRegion']" />
								</modernRegion>
								<modernProvince>
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//tei:provenance[@type='found']/tei:placeName[@type='modernProvince']/@ref" />
                                    </xsl:attribute>
									<xsl:value-of select="//tei:provenance[@type='found']/tei:placeName[@type='modernProvince']" />
								</modernProvince>
							</findingSpot>
							<conservationPlace>
								<conservationCountry>
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//tei:country/tei:placeName[@type='modern']/@ref" />
                                    </xsl:attribute>
									<xsl:value-of select="//tei:country/tei:placeName[@type='modern']" />
								</conservationCountry>
								<conservationRegion >
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//tei:region/tei:placeName[@type='modern']/@ref" />
                                    </xsl:attribute>
									<xsl:value-of select="//tei:region/tei:placeName[@type='modern']" />
								</conservationRegion>
								<conservationCity>
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//tei:settlement/tei:placeName[@type='modern']/@ref" />
                                    </xsl:attribute>
									<xsl:value-of select="//tei:settlement/tei:placeName[@type='modern']" />
								</conservationCity>
								<museum>
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//tei:msIdentifier/tei:repository/@ref" />
                                    </xsl:attribute>
									<xsl:value-of select="//tei:msIdentifier/tei:repository" />
								</museum>
								<position>
									<xsl:value-of select="//tei:msIdentifier/tei:collection" />
								</position>
								<inventoryNumber>
									<xsl:value-of select="//tei:msIdentifier/tei:idno" />
								</inventoryNumber>
							</conservationPlace>
							<!-- ARTIFACT+INSCRIPTION -->
							<inscription>
								<refersTrismegistosCard>
									<xsl:attribute name="tm_id">
										<xsl:value-of select="//tei:publicationStmt/idno[@type='TM_id']"></xsl:value-of>
									</xsl:attribute>###refersTrismegistosCard0</refersTrismegistosCard>
								<inscriptionType>
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//tei:keywords/tei:term/@ref" />
                                    </xsl:attribute>
									<xsl:value-of select="//tei:keywords/tei:term" />
								</inscriptionType>
								<engravingTechnique>
									<xsl:attribute name="uri">
                                        <xsl:value-of select="//tei:rs[type='execution']/@ref" />
                                    </xsl:attribute>
									<xsl:value-of select="//tei:rs[type='execution']/@ref" />
								</engravingTechnique>
								<metre>
									<xsl:value-of select="//tei:rs[type='metre']" />
								</metre>
								<fieldSize>
									<xsl:attribute name="unit">
                                        <xsl:value-of select="//tei:layout/tei:dimensions/tei:width/@unit" />
                                    </xsl:attribute>
									<width><xsl:value-of select="//tei:layout/tei:dimensions/tei:width" /></width>
									<height><xsl:value-of select="//tei:layout/tei:dimensions/tei:height" /></height>
								</fieldSize>
								<paleographicCharacteristics>
									<xsl:value-of select="//tei:handDesc/tei:handNote" />
								</paleographicCharacteristics>
								<letterSize unit="unit5">
									<width>0</width>
									<height>0</height>
								</letterSize>
<!-- 								Properties down here are not present in EpiDoc. Can be initialized only for STARC metadata-->
<!-- 								<inscriptionAuthor>inscriptionAuthor0</inscriptionAuthor> -->
<!-- 								<honorand socialStatus="socialStatus1">honorand0</honorand> -->
<!-- 								<dedicator>dedicator0</dedicator> -->
<!-- 								<namesMentioned>namesMentioned0</namesMentioned> -->
<!-- 								<relatedEvent>relatedEvent0</relatedEvent> -->
<!-- 								<placesMentioned>placesMentioned0</placesMentioned> -->
<!-- 								<restorationInfo>restorationInfo0</restorationInfo> -->
<!-- 								<doubleSided>doubleSided0</doubleSided> -->
<!-- 								<erasures>erasures0</erasures> -->
<!-- 								<spellingErrors>spellingErrors0</spellingErrors> -->
								<xsl:for-each select="tei:facsimile/tei:graphic">
									<hasInscriptionVisualRepresentation>
										<xsl:attribute name="uri">thumbnail</xsl:attribute>
										<xsl:value-of select="concat('visual::', $CP_ACRONYM, '::', $LOCAL_ID_MD5, '::', position)" />
									</hasInscriptionVisualRepresentation>
								</xsl:for-each>
								<hasTranslation>###relTranslationObj###</hasTranslation>
								<hasTranscription>
									<xsl:value-of select="concat('transcription::', $CP_ACRONYM, '::', $LOCAL_ID_MD5)" />
								</hasTranscription>
							</inscription>
						</artifact>
					</eagleObject>
				</metadata>
			</record>
			
			<!-- TRANSCRIPTION -->
			<record>
				<header>
					<dri:objIdentifier>
						<xsl:value-of select="concat($ORIG_OBJ_ID, '_transcription')" />
					</dri:objIdentifier>
					<dri:dateOfCollection>
						<xsl:value-of select="$NOW" />
					</dri:dateOfCollection>
					<dri:repositoryId>
						<xsl:value-of select="$REPO_ID" />
					</dri:repositoryId>
				</header>
				<metadata>
					<eagleObject>
						<dnetResourceIdentifier>
							<xsl:value-of select="concat('doc::', $CP_ACRONYM, '::', $LOCAL_ID_MD5)" />
						</dnetResourceIdentifier>
						<xsl:call-template name="commonProperties" />
						<entityType>Documental manifestation</entityType>
						<documentType>Transcription</documentType>
					    <transcription>
					        <text type="sic" lang="lang1">text0</text>
					        <criticalApparatus>criticalApparatus0</criticalApparatus>
					        <criticalApparatus>criticalApparatus1</criticalApparatus>
					        <bibliography uri="http://www.oxygenxml.com/">bibliography0</bibliography>
					        <bibliography uri="http://www.oxygenxml.com/">bibliography1</bibliography>
					        <commentary>commentary0</commentary>
					        <commentary>commentary1</commentary>
					        <isTranscriptionOf>isTranscriptionOf0</isTranscriptionOf>
					        <isTranscriptionOf>isTranscriptionOf1</isTranscriptionOf>
					    </transcription>
					</eagleObject>
				</metadata>
			</record>
			
			<!-- VISUAL REPRESENTATION -->
			<xsl:for-each select="tei:facsimile/tei:graphic">
				<record>
					<header>
						<dri:objIdentifier>
							<xsl:value-of select="concat($ORIG_OBJ_ID, '_visual', position)" />
						</dri:objIdentifier>
						<dri:dateOfCollection>
							<xsl:value-of select="$NOW" />
						</dri:dateOfCollection>
						<dri:repositoryId>
							<xsl:value-of select="$REPO_ID" />
						</dri:repositoryId>
					</header>
					<metadata>
						<eagleObject>
							<dnetResourceIdentifier>
								<xsl:value-of select="concat('visual::', $CP_ACRONYM, '::', $LOCAL_ID_MD5)" />
							</dnetResourceIdentifier>
							<xsl:call-template name="commonProperties" />
							<entityType>Visual representation</entityType>
							<visualRepresentation>
							    <representationType>Image</representationType>
							    <url>http://www.oxygenxml.com/</url>
							    <thumbnail>http://www.oxygenxml.com/</thumbnail>
							    <author>author0</author>
							    <visualRepresentationIpr uri="http://www.oxygenxml.com/">visualRepresentationIpr0</visualRepresentationIpr>
							    <creationDate>creationDate0</creationDate>
							    <quality>quality0</quality>
							    <format>format0</format>
							    <isRepresentationOf>isRepresentationOf0</isRepresentationOf>
							    <isRepresentationOf>isRepresentationOf1</isRepresentationOf>
							    <info3D>
							        <acquisitionTechnology>acquisitionTechnology0</acquisitionTechnology>
							        <processingInfo>processingInfo0</processingInfo>
							        <horizontalResolution>horizontalResolution0</horizontalResolution>
							        <verticalResolution>verticalResolution0</verticalResolution>
							        <modelDimensions unit="unit1">
							            <width>0</width>
							            <height>0</height>
							            <depth>0</depth>
							        </modelDimensions>
							        <modelArea>modelArea0</modelArea>
							        <modelPerimeter>modelPerimeter0</modelPerimeter>
							    </info3D>
							    <infoVideo>
							        <duration>duration0</duration>
							        <resolution>resolution0</resolution>
							        <rate>rate0</rate>
							    </infoVideo>
							</visualRepresentation>
						</eagleObject>
					</metadata>
				</record>
			</xsl:for-each>
		</package>
	</xsl:template>
</xsl:stylesheet>
