/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.config;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class ConfigurationFactory
implements FactoryBean {
    private static final Log log = LogFactory.getLog(ConfigurationFactory.class);
    private Resource defaults;

    public Configuration getConfiguration() {
        try {
            return (Configuration)this.getObject();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to load hadoop configuration", e);
        }
    }

    public Object getObject() throws Exception {
        return this.initConfiguration(this.defaultProperties());
    }

    public Class<?> getObjectType() {
        return Configuration.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private Configuration initConfiguration(Properties p) {
        Configuration conf = new Configuration(false);
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            conf.set(e.getKey().toString(), e.getValue().toString());
            log.info((Object)(e.getKey().toString() + ": " + conf.get(e.getKey().toString())));
        }
        return conf;
    }

    private Properties defaultProperties() throws IOException {
        Properties p = new Properties();
        p.load(this.defaults.getInputStream());
        return p;
    }

    public Resource getDefaults() {
        return this.defaults;
    }

    @Required
    public void setDefaults(Resource defaults) {
        this.defaults = defaults;
    }
}

