package eu.dnetlib.msro.oai.workflows.nodes;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.oai.workflows.InaccurateProgressProvider;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.util.ProgressProvider;

public class OAIEnsureIndexesJobNode extends BlackboardJobNode implements ProgressJobNode {

	private static final Log log = LogFactory.getLog(OAIEnsureIndexesJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String mdPrefix;

	@Override
	protected String getXqueryForServiceId(final NodeToken token) {
		return "//RESOURCE_IDENTIFIER[../RESOURCE_TYPE/@value='OAIStoreServiceResourceType']/@value/string()";
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws ResultSetException {
		job.setAction("ENSURE_INDEXES");
		if (StringUtils.isNotBlank(mdPrefix)) {
			job.getParameters().put("ensure_mdPrefix", mdPrefix);
		} else {
			log.debug("mdPrefix not set");
		}
	}

	@Override
	public ProgressProvider getProgressProvider() {
		return new InaccurateProgressProvider();
	}

	public String getMdPrefix() {
		return mdPrefix;
	}

	public void setMdPrefix(final String mdPrefix) {
		this.mdPrefix = mdPrefix;
	}

}
