/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.oai;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationExistReader;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationWriter;
import eu.dnetlib.data.information.oai.publisher.conf.sync.SchedulableOAIStoreAllCounters;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.data.information.oai.publisher.store.MongoPublisherStoreDAO;
import eu.dnetlib.data.information.oai.publisher.store.PublisherField;
import eu.dnetlib.data.information.oai.publisher.store.sync.SchedulableContentSynchronizer;
import eu.dnetlib.functionality.modular.ui.oai.IndexPath;
import eu.dnetlib.functionality.modular.ui.oai.OAIIndex;
import eu.dnetlib.functionality.modular.ui.oai.TDSRule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class OAIInternalController {
    @Resource
    private OAIConfigurationExistReader configuration;
    @Resource
    private OAIConfigurationWriter configurationWriter;
    @Resource
    private SchedulableContentSynchronizer oaiContentSynchronizer;
    @Resource
    private MongoPublisherStoreDAO mongoPublisherStoreDAO;
    @Resource
    private SchedulableOAIStoreAllCounters oaiSetCounter;
    private static final Log log = LogFactory.getLog(OAIInternalController.class);

    @RequestMapping(value={"/ui/getExportMDFs.do"})
    public void getExportMDFs(HttpServletResponse response) throws Exception {
        List exportMDFs = this.configuration.getMetadataFormatInfo();
        String json = new Gson().toJson((Object)exportMDFs);
        IOUtils.copy((Reader)new StringReader(json), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/getSourceMDFs.do"})
    public void getSourceMDFs(HttpServletResponse response) throws Exception {
        List exportMDFs = this.configuration.getMetadataFormatInfo();
        List srcMDFList = Lists.transform((List)exportMDFs, (Function)new Function<MDFInfo, MDFInfo>(){

            public MDFInfo apply(MDFInfo mdf) {
                MDFInfo srcOnly = new MDFInfo();
                srcOnly.setSourceFormatName(mdf.getSourceFormatName());
                srcOnly.setSourceFormatLayout(mdf.getSourceFormatLayout());
                srcOnly.setSourceFormatInterpretation(mdf.getSourceFormatInterpretation());
                return srcOnly;
            }
        });
        ImmutableList srcMDFs = ImmutableSet.copyOf((Collection)srcMDFList).asList();
        String json = new Gson().toJson((Object)srcMDFs);
        log.info((Object)json);
        IOUtils.copy((Reader)new StringReader(json), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/getSetSpecs.do"})
    public void getSetSpecs(HttpServletResponse response) throws Exception {
        String json = new Gson().toJson((Object)this.configuration.getSetSpecs());
        IOUtils.copy((Reader)new StringReader(json), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/getMetadataFormat.do"})
    public void getMetadataFormat(HttpServletResponse response, @RequestParam(value="mdPrefix", required=true) String mdPrefix) throws Exception {
        MDFInfo mdf = this.configuration.getMetadataFormatInfo(mdPrefix);
        String mdfJson = new Gson().toJson((Object)mdf);
        IOUtils.copy((Reader)new StringReader(mdfJson), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/saveMetadataFormat.do"}, method={RequestMethod.POST})
    public void saveMetadataFormat(HttpServletResponse response, HttpServletRequest request, @RequestParam(value="mdPrefix", required=true) String mdPrefix) throws Exception {
        MDFInfo update = (MDFInfo)new Gson().fromJson((Reader)request.getReader(), MDFInfo.class);
        if (update.getBaseQuery() == null) {
            update.setBaseQuery("");
        }
        if (update.getTransformationRuleID() == null) {
            update.setTransformationRuleID("");
        }
        log.info((Object)("Update to object" + update));
        boolean result = false;
        if (this.configuration.getMetadataFormatInfo(mdPrefix) != null) {
            log.info((Object)("UPDATING mdPrefix = " + mdPrefix));
            result = this.configurationWriter.updateMetadataFormat(mdPrefix, update);
        } else {
            log.info((Object)("CREATING new mdPrefix = " + mdPrefix));
            result = this.configurationWriter.addMetadataFormat(update);
        }
        response.getWriter().print(result);
    }

    @RequestMapping(value={"/ui/deleteMetadataFormat.do"})
    public void deleteMetadataFormat(HttpServletResponse response, @RequestParam(value="mdPrefix", required=true) String mdPrefix) throws Exception {
        boolean result = this.configurationWriter.deleteMetadataFormat(mdPrefix);
        response.getWriter().print(result);
    }

    @RequestMapping(value={"/ui/showSetDetails.do"})
    public void showSetDetails(HttpServletResponse response, @RequestParam(value="setSpec", required=true) String setSpec) throws Exception {
        SetInfo set = this.configuration.getSetInfo(setSpec);
        String json = new Gson().toJson((Object)set);
        IOUtils.copy((Reader)new StringReader(json), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/saveOAISet.do"}, method={RequestMethod.POST})
    public void saveOAISet(HttpServletResponse response, HttpServletRequest request, @RequestParam(value="setSpec", required=true) String setSpec) throws Exception {
        log.info((Object)("setSpec = " + setSpec));
        SetInfo update = (SetInfo)new Gson().fromJson((Reader)request.getReader(), SetInfo.class);
        log.info((Object)("Update to object" + update));
        boolean result = false;
        if (this.configuration.getSetInfo(setSpec) != null) {
            log.info((Object)("UPDATING set = " + setSpec));
            result = this.configurationWriter.updateOAISet(setSpec, update);
        } else {
            log.info((Object)("CREATING new OAIset = " + setSpec));
            result = this.configurationWriter.addOAISet(update);
        }
        response.getWriter().print(result);
    }

    @RequestMapping(value={"/ui/deleteOAISet.do"})
    public void deleteOAISet(HttpServletResponse response, @RequestParam(value="setSpec", required=true) String setSpec) throws Exception {
        boolean result = this.configurationWriter.deleteOAISet(setSpec);
        response.getWriter().print(result);
    }

    @RequestMapping(value={"/ui/showIndices.do"})
    public void showIndices(HttpServletResponse response, @RequestParam(value="format", required=true) String format, @RequestParam(value="layout", required=true) String layout, @RequestParam(value="interpretation", required=true) String interpretation) throws Exception {
        List fields = this.configuration.getFields(format, interpretation, layout);
        ArrayList indices = Lists.newArrayList();
        for (PublisherField field : fields) {
            Collection paths = field.getSources().get((Object)(format + "-" + layout + "-" + interpretation));
            ArrayList pathList = Lists.newArrayList();
            for (String p : paths) {
                pathList.add(new IndexPath(p));
            }
            OAIIndex idx = new OAIIndex();
            idx.setRepeatable(field.isRepeatable());
            idx.setName(field.getFieldName());
            idx.setPaths(pathList);
            indices.add(idx);
        }
        String json = new Gson().toJson((Object)indices);
        log.info((Object)("The map of indices: " + json));
        IOUtils.copy((Reader)new StringReader(json), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/saveIndices.do"}, method={RequestMethod.POST})
    public void saveIndices(HttpServletResponse response, HttpServletRequest request, @RequestParam(value="format", required=true) String format, @RequestParam(value="layout", required=true) String layout, @RequestParam(value="interpretation", required=true) String interpretation) throws Exception {
        StringWriter sw = new StringWriter();
        IOUtils.copy((InputStream)request.getInputStream(), (Writer)sw);
        Type collectionType = new TypeToken<List<OAIIndex>>(){}.getType();
        List indexes = (List)new Gson().fromJson(sw.toString(), collectionType);
        final String mdformatKey = format + "-" + layout + "-" + interpretation;
        List updatedIndices = Lists.transform((List)indexes, (Function)new Function<OAIIndex, PublisherField>(){

            public PublisherField apply(OAIIndex oaiIndex) {
                PublisherField f = new PublisherField();
                f.setFieldName(oaiIndex.getName());
                f.setRepeatable(oaiIndex.isRepeatable());
                ArrayListMultimap paths = ArrayListMultimap.create();
                for (IndexPath path : oaiIndex.getPaths()) {
                    paths.put((Object)mdformatKey, (Object)path.getPath());
                }
                f.setSources((Multimap)paths);
                return f;
            }
        });
        log.info((Object)("Updating indices" + indexes));
        boolean result = this.configurationWriter.updateIndices(format, layout, interpretation, updatedIndices);
        response.getWriter().print(result);
    }

    @RequestMapping(value={"/ui/saveNewIndex.do"})
    public void saveNewIndex(HttpServletResponse response, @RequestParam(value="format", required=true) String format, @RequestParam(value="layout", required=true) String layout, @RequestParam(value="interpretation", required=true) String interpretation, @RequestParam(value="indexName", required=true) String indexName, @RequestParam(value="repeatable", required=true) boolean repeatable, @RequestParam(value="paths", required=true) String paths) throws Exception {
        String[] thePaths = paths.split(",");
        boolean result = this.configurationWriter.addNewIndex(format, layout, interpretation, indexName, repeatable, thePaths);
        response.getWriter().print(result);
    }

    @RequestMapping(value={"/ui/saveNewPathIndex.do"})
    public void saveNewPathIndex(HttpServletResponse response, final @RequestParam(value="format", required=true) String format, final @RequestParam(value="layout", required=true) String layout, final @RequestParam(value="interpretation", required=true) String interpretation, final @RequestParam(value="indexName", required=true) String indexName, final @RequestParam(value="newPath", required=true) String newPath) throws Exception {
        List fields = this.configurationWriter.getConfiguration().getFields(format, interpretation, layout);
        Iterable updated = Iterables.transform((Iterable)fields, (Function)new Function<PublisherField, PublisherField>(){

            public PublisherField apply(PublisherField field) {
                if (field.getFieldName().equals(indexName)) {
                    field.getSources().get((Object)(format + "-" + layout + "-" + interpretation)).add(newPath);
                }
                return field;
            }
        });
        boolean result = this.configurationWriter.updateIndices(format, layout, interpretation, (List)Lists.newArrayList((Iterable)updated));
        response.getWriter().print(result);
    }

    @RequestMapping(value={"/ui/getTransformationRules.do"})
    public void getTransformationRules(HttpServletResponse response) throws IOException {
        String query = "for $x in collection('/db/DRIVER/TransformationRuleDSResources/TransformationRuleDSResourceType') return concat($x//RESOURCE_IDENTIFIER/@value/string(), ':-:', $x//CONFIGURATION//TITLE)";
        Iterable rules = this.configuration.getQueryExecutor().query(TDSRule.class, "for $x in collection('/db/DRIVER/TransformationRuleDSResources/TransformationRuleDSResourceType') return concat($x//RESOURCE_IDENTIFIER/@value/string(), ':-:', $x//CONFIGURATION//TITLE)");
        String json = new Gson().toJson((Object)Lists.newArrayList((Iterable)rules));
        IOUtils.copy((Reader)new StringReader(json), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/synchContent.do"})
    public void synchronizeContent(HttpServletResponse response) throws IOException {
        boolean enabled = this.oaiContentSynchronizer.isEnabled();
        if (!enabled) {
            this.oaiContentSynchronizer.setEnabled(true);
        }
        this.oaiContentSynchronizer.execute();
        this.oaiContentSynchronizer.setEnabled(enabled);
        response.getWriter().print(true);
    }

    @RequestMapping(value={"/ui/updateSetCounters.do"})
    public void updateSetCounters(HttpServletResponse response) throws IOException {
        boolean enabled = this.oaiSetCounter.isEnabled();
        if (!enabled) {
            this.oaiSetCounter.setEnabled(true);
        }
        this.oaiSetCounter.execute();
        this.oaiSetCounter.setEnabled(enabled);
        response.getWriter().print(true);
    }

    @RequestMapping(value={"/ui/ensureIndexes.do"})
    public void ensureIndexes(HttpServletResponse response) throws IOException {
        this.mongoPublisherStoreDAO.ensureIndex(3);
        response.getWriter().print(true);
    }

    public SchedulableContentSynchronizer getOaiContentSynchronizer() {
        return this.oaiContentSynchronizer;
    }

    public void setOaiContentSynchronizer(SchedulableContentSynchronizer oaiContentSynchronizer) {
        this.oaiContentSynchronizer = oaiContentSynchronizer;
    }

    public MongoPublisherStoreDAO getMongoPublisherStoreDAO() {
        return this.mongoPublisherStoreDAO;
    }

    public void setMongoPublisherStoreDAO(MongoPublisherStoreDAO mongoPublisherStoreDAO) {
        this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
    }

    public SchedulableOAIStoreAllCounters getOaiSetCounter() {
        return this.oaiSetCounter;
    }

    public void setOaiSetCounter(SchedulableOAIStoreAllCounters oaiSetCounter) {
        this.oaiSetCounter = oaiSetCounter;
    }
}

