<!-- Modal to add new metadata format -->
<div id="mdfModal" class="modal hide fade" tabindex="-1" role="dialog"
	aria-labelledby="mdfModalLabel" aria-hidden="true">
	<form class="modal-form"
		ng-submit="saveExportMetadataFormat(modalMdf.prefix, modalMdf)">
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal"
				aria-hidden="true">&times;</button>
			<h3 id="mdfModalLabel">New OAI Metadata Format</h3>
		</div>
		<div class="modal-body">
			<div class="control-group">
				<label class="control-label" for="prefix">Prefix</label>
				<div class="controls">
					<input ng-model="modalMdf.prefix" required id="prefix" type="text" />
				</div>
			</div>
			<div class="control-group">
				<label class="control-label" for="schema">Schema</label>
				<div class="controls">
					<input class="input-xxlarge" ng-model="modalMdf.schema" required
						id="schema" type="text" />
				</div>
			</div>
			<div class="control-group">
				<label class="control-label" for="namespace">Namespace</label>
				<div class="controls">
					<input class="input-xxlarge" ng-model="modalMdf.namespace" required
						id="namespace" type="text" />
				</div>
			</div>

			<div class="control-group">
				<label class="control-label">Source Format</label>
				<div class="controls">
					<div class="input-prepend">
						<span class="add-on">Name:</span> <input
							ng-model="modalMdf.sourceFormatName" required placeholder="name"
							type="text" />
					</div>
					<div class="input-prepend">
						<span class="add-on">Layout:</span> <input
							ng-model="modalMdf.sourceFormatLayout" required
							placeholder="layout" type="text" />
					</div>
					<div class="input-prepend">
						<span class="add-on">Interpretation:</span> <input
							ng-model="modalMdf.sourceFormatInterpretation" required
							placeholder="interpretation" type="text" />
					</div>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label" for="query">Base query</label>
				<div class="controls">
					<input class="input-xxlarge" ng-model="modalMdf.baseQuery"
						id="query" type="text" />
				</div>
			</div>
			<div class="control-group">
				<label class="control-label" for="tds">Transformation Rule</label>
				<div class="controls">
					<input class="input-xxlarge" type="text"
						ng-model="modalMdf.transformationRuleID" id="tds" />
				</div>
			</div>
			<div class="control-group">
				<label class="control-label" for="enabled">Enabled</label>
				<div class="controls">
					<input type="checkbox" ng-model="modalMdf.enabled" id="enabled" />
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<div class="control-group">
				<div class="controls">
					<button class="btn btn-primary" type="submit">Save</button>
				</div>
			</div>
		</div>
	</form>
</div>

<!-- Modal to add new set  -->
<div id="setModal" class="modal hide fade" tabindex="-1" role="dialog"
	aria-labelledby="setModalLabel" aria-hidden="true">
	<form class="modal-form"
		ng-submit="saveOAISet(modalSet.setSpec, modalSet)">
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal"
				aria-hidden="true">&times;</button>
			<h3 id="setModalLabel">New OAI Set</h3>
		</div>
		<div class="modal-body">
			<div class="control-group">
				<label class="control-label" for="enabled">Enabled</label>
				<div class="controls">
					<input type="checkbox" ng-model="modalSet.enabled" id="enabled" />
				</div>
			</div>
			<div class="control-group">
				<label class="control-label" for="spec">SetSpec</label>
				<div class="controls">
					<input ng-model="modalSet.setSpec" required id="spec" type="text" />
				</div>
			</div>
			<div class="control-group">
				<label class="control-label" for="name">Name</label>
				<div class="controls">
					<input class="input-xxlarge" ng-model="modalSet.setName" required
						id="name" type="text" />
				</div>
			</div>
			<div class="control-group">
				<label class="control-label" for="descr">Description</label>
				<div class="controls">
					<textarea rows="10" ng-model="modalSet.setDescription" required
						id="descr" class="input-xxlarge"></textarea>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label" for="prefix">Query</label>
				<div class="controls">
					<input class="input-xxlarge" ng-model="modalSet.query" required
						id="query" type="text" />
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<div class="control-group">
				<div class="controls">
					<button class="btn btn-primary" type="submit">Save</button>
				</div>
			</div>
		</div>
	</form>
</div>


<!-- Modal to add new index  -->
<div id="indexModal" class="modal hide fade" tabindex="-1" role="dialog"
	aria-labelledby="indexModalLabel" aria-hidden="true">
	<form class="modal-form" ng-submit="saveNewIndex(currentMdf.sourceFormatName, currentMdf.sourceFormatLayout, currentMdf.sourceFormatInterpretation, modalIndex)">
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal"
				aria-hidden="true">&times;</button>
			<h3 id="indexModalLabel">New Index:</h3>
		</div>
		<div class="modal-body">
			<div class="control-group">
				<label class="control-label" for="idxName">Index name</label>
				<div class="controls">
					<input ng-model="modalIndex.name" required id="idxName" type="text" />
					<select ng-model="modalIndex.repeatable" required>
						<option value="true" ng-selected="modalIndex.repeatable">Repeatable</option>
						<option value="false" ng-selected="!modalIndex.repeatable">Single value</option>
					</select>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label" for="path">Path (multiple paths
					as ',' separated field)</label>
				<div class="controls">
					<input class="input-xxlarge" ng-model="modalIndex.paths" required
						id="path" type="text" />
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<div class="control-group">
				<div class="controls">
					<button class="btn btn-primary" type="submit">Save</button>
				</div>
			</div>
		</div>
	</form>
</div>

<!-- Modal to add new path to an index  -->
<div id="indexPathModal" class="modal hide fade" tabindex="-1" role="dialog"
	aria-labelledby="indexPathModalLabel" aria-hidden="true">
	<form class="modal-form" ng-submit="saveNewPathIndex(currentMdf.sourceFormatName, currentMdf.sourceFormatLayout, currentMdf.sourceFormatInterpretation, modalIndex.name, newPath)">
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal"
				aria-hidden="true">&times;</button>
			<h3 id="indexPathModalLabel">New path for index {{modalIndex.name}}</h3>
		</div>
		<div class="modal-body">
			<div class="control-group">
				<label class="control-label" for="path">Path:</label>
				<div class="controls">
					<input class="input-xxlarge" ng-model="newPath" id="newPath" type="text" required />
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<div class="control-group">
				<div class="controls">
					<button class="btn btn-primary" type="submit">Save</button>
				</div>
			</div>
		</div>
	</form>
</div>
