package eu.dnetlib.oai.init.hdfs;

import javax.annotation.Resource;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.store.sync.OAIStoreContentSynchronizer;
import eu.dnetlib.data.information.oai.publisher.store.sync.OAIStoreContentSynchronizerFactory;

public class HDFSOAIInitializerFactory extends OAIStoreContentSynchronizerFactory {

	private Path filePath;
	@Resource
	private ConfigurationEnumerator configurationEnumerator;

	private int limitRead = -1;

	@Override
	public OAIStoreContentSynchronizer create(final MDFInfo mdfInfo) {
		Configuration conf = configurationEnumerator.get(ClusterName.DM);
		return new PublisherInitializerHDFS(mdfInfo, getPublisherStoreDAO(), filePath, conf, limitRead);
	}

	public Path getFilePath() {
		return filePath;
	}

	@Required
	public void setFilePath(final Path filePath) {
		this.filePath = filePath;
	}

	public int getLimitRead() {
		return limitRead;
	}

	public void setLimitRead(final int limitRead) {
		this.limitRead = limitRead;
	}

}
