package eu.dnetlib.data.oai.store.actions;

import java.util.concurrent.Callable;

import javax.annotation.Resource;

import eu.dnetlib.data.oai.store.sync.OAIStoreSynchronizer;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class SyncAction extends AbstractOAIStoreAction implements BlackboardServerAction<OAIStoreActions> {

	@Resource
	private OAIStoreSynchronizer synchronizer;

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
		boolean forceContentSync = Boolean.valueOf(job.getParameters().get("forceContentSync"));
		this.synchronizer.synchronize(forceContentSync, new Callable<Object>() {

			@Override
			public Object call() {
				// job.getParameters().put("total", "" + getDao().getMDStore(mdId).getSize());
				handler.done(job);
				return null;
			}
		}, new Callable<Object>() {

			@Override
			public Object call() {
				handler.failed(job, new Exception("Error during OAI synchronization"));
				return null;
			}
		});

	}

	public OAIStoreSynchronizer getSynchronizer() {
		return synchronizer;
	}

	public void setSynchronizer(final OAIStoreSynchronizer synchronizer) {
		this.synchronizer = synchronizer;
	}

}
