package eu.dnetlib.data.oai.store.parser;

import java.io.StringReader;
import java.util.Map.Entry;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;

/**
 * An instance of this class can parse an XML record and extract the information needed to store the record in a publisher store.
 * 
 * 
 * @author alessia
 * 
 */
public class PublisherRecordParser {

	private static final Log log = LogFactory.getLog(PublisherRecordParser.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * Maps of the indices of the target store. Each key is an index name, the value is the xpath.
	 */
	private Multimap<String, String> storeIndices;

	private final SAXReader saxReader = new SAXReader();

	/**
	 * Parses the record and returns a map where a key is the name of an index, the value is the value in the record at the xpath specificed
	 * in this.storeIndices.
	 * 
	 * @param record
	 *            the XML string to parse.
	 * @return a Multimap describing the values to be indexed for this record.
	 */
	public Multimap<String, String> parseRecord(final String record) {
		Multimap<String, String> recordProps = ArrayListMultimap.create();
		try {
			Document doc = this.saxReader.read(new StringReader(record));
			for (Entry<String, String> indexEntry : this.storeIndices.entries()) {
				String value = doc.valueOf(indexEntry.getValue());
				recordProps.put(indexEntry.getKey(), value);
			}
		} catch (DocumentException e) {
			log.fatal("Can't parse record");
			recordProps = null;
		}
		return recordProps;

	}

	public Multimap<String, String> getStoreIndices() {
		return storeIndices;
	}

	public void setStoreIndices(final Multimap<String, String> storeIndices) {
		this.storeIndices = storeIndices;
	}

	public SAXReader getSaxReader() {
		return saxReader;
	}

	public PublisherRecordParser(final Multimap<String, String> storeIndices) {
		super();
		this.storeIndices = storeIndices;
	}

	public PublisherRecordParser() {
		super();
		// TODO Auto-generated constructor stub
	}

}
