package eu.dnetlib.data.oai.store.sync;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStoreDAO;

public abstract class OAIStoreInitializer implements Runnable {

	private static final Log log = LogFactory.getLog(OAIStoreInitializer.class); // NOPMD by marko on 11/24/08 5:02 PM

	private MDFInfo mdfInfo;
	private MongoPublisherStoreDAO publisherStoreDAO;
	private boolean forceContentSynchronization;

	@Override
	public void run() {
		log.info("Checking configuration for metadata prefix " + mdfInfo.getPrefix());
		log.debug(mdfInfo);
		MongoPublisherStore store = this.publisherStoreDAO.getStoreFor(mdfInfo.getPrefix());
		if (store == null) {
			log.debug("Creating store for metadata format: \n" + mdfInfo);
			try {
				store = this.publisherStoreDAO.createStore(mdfInfo.getSourceFormatName(), mdfInfo.getSourceFormatInterpretation(),
						mdfInfo.getSourceFormatLayout());
				log.debug("Created store with id: " + store.getId());
				this.synchronizeContent(store);
			} catch (OaiPublisherException e) {
				throw new OaiPublisherRuntimeException(e);
			}
		} else {
			if (this.forceContentSynchronization) {
				this.synchronizeContent(store);
			}

		}
		log.info("Updated configuration for metadata prefix " + mdfInfo.getPrefix());
	}

	protected abstract void synchronizeContent(final MongoPublisherStore store);

	public OAIStoreInitializer() {
		super();
	}

	public OAIStoreInitializer(final MDFInfo mdfInfo, final MongoPublisherStoreDAO publisherStoreDAO, final boolean forceContentSynchronization) {
		super();
		this.mdfInfo = mdfInfo;
		this.publisherStoreDAO = publisherStoreDAO;
		this.forceContentSynchronization = forceContentSynchronization;
	}

	public MDFInfo getMdfInfo() {
		return mdfInfo;
	}

	public void setMdfInfo(final MDFInfo mdfInfo) {
		this.mdfInfo = mdfInfo;
	}

	public MongoPublisherStoreDAO getPublisherStoreDAO() {
		return publisherStoreDAO;
	}

	public void setPublisherStoreDAO(final MongoPublisherStoreDAO publisherStoreDAO) {
		this.publisherStoreDAO = publisherStoreDAO;
	}

	public boolean isForceContentSynchronization() {
		return forceContentSynchronization;
	}

	public void setForceContentSynchronization(final boolean forceContentSynchronization) {
		this.forceContentSynchronization = forceContentSynchronization;
	}

}
