/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.parser;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class PublisherRecordParser {
    private static final Log log = LogFactory.getLog(PublisherRecordParser.class);
    private Multimap<String, String> storeIndices;
    private final SAXReader saxReader = new SAXReader();

    public Multimap<String, String> parseRecord(String record) {
        ArrayListMultimap recordProps = ArrayListMultimap.create();
        try {
            Document doc = this.saxReader.read((Reader)new StringReader(record));
            for (Map.Entry indexEntry : this.storeIndices.entries()) {
                String value = doc.valueOf((String)indexEntry.getValue());
                recordProps.put(indexEntry.getKey(), (Object)value);
            }
        }
        catch (DocumentException e) {
            log.fatal((Object)"Can't parse record");
            recordProps = null;
        }
        return recordProps;
    }

    public Multimap<String, String> getStoreIndices() {
        return this.storeIndices;
    }

    public void setStoreIndices(Multimap<String, String> storeIndices) {
        this.storeIndices = storeIndices;
    }

    public SAXReader getSaxReader() {
        return this.saxReader;
    }

    public PublisherRecordParser(Multimap<String, String> storeIndices) {
        this.storeIndices = storeIndices;
    }

    public PublisherRecordParser() {
    }
}

