package eu.dnetlib.data.oai.store;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.data.oai.store.sync.OAIStoreSynchronizer;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;

public class OAIStoreServiceImpl extends AbstractBaseService implements OAIStoreService {

	/**
	 * notification handler.
	 */
	private NotificationHandler notificationHandler;

	@Resource
	private OAIStoreSynchronizer synchronizer;

	@Override
	public void synchronize(final boolean forceContentSync) {
		this.synchronizer.synchronize(forceContentSync, null, null);
	}

	@Override
	public void notify(final String subscriptionId, final String topic, final String isId, final String message) {
		getNotificationHandler().notified(subscriptionId, topic, isId, message);
	}

	public NotificationHandler getNotificationHandler() {
		return notificationHandler;
	}

	@Required
	public void setNotificationHandler(final NotificationHandler notificationHandler) {
		this.notificationHandler = notificationHandler;
	}

	public OAIStoreSynchronizer getSynchronizer() {
		return synchronizer;
	}

	public void setSynchronizer(final OAIStoreSynchronizer synchronizer) {
		this.synchronizer = synchronizer;
	}

}
