/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.mongo;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.conf.PublisherConfigurationReader;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.oai.store.PublisherStoreDAO;
import eu.dnetlib.data.oai.store.RecordChangeDetector;
import eu.dnetlib.data.oai.store.mongo.MetadataExtractor;
import eu.dnetlib.data.oai.store.mongo.MongoCursor;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.mongo.RecordInfoGenerator;
import eu.dnetlib.data.oai.store.parser.MongoQueryParser;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Required;

public class MongoPublisherStoreDAO
implements PublisherStoreDAO<MongoPublisherStore, MongoCursor> {
    @Resource(name="publisherMongoDB")
    private DB publisherDB;
    @Resource
    private RecordInfoGenerator recordInfoGenerator;
    @Resource
    private MetadataExtractor metadataExtractor;
    @Resource
    private MongoQueryParser queryParser;
    @Resource
    private PublisherConfigurationReader configuration;
    @Resource
    private RecordChangeDetector recordChangeDetector;
    private String metadataCollection;

    @Override
    public List<MongoPublisherStore> listPublisherStores() {
        ArrayList stores = Lists.newArrayList();
        DBCursor cursor = this.publisherDB.getCollection(this.metadataCollection).find();
        for (DBObject storeInfo : cursor) {
            stores.add(this.createFromDBObject(storeInfo));
        }
        return stores;
    }

    @Override
    public MongoPublisherStore getStore(String storeId) {
        DBObject storeInfo = this.publisherDB.getCollection(this.metadataCollection).findOne((DBObject)new BasicDBObject("id", (Object)storeId));
        return this.createFromDBObject(storeInfo);
    }

    @Override
    public MongoPublisherStore getStore(String mdfName, String mdfInterpretation, String mdfLayout) {
        return this.getStore(this.generateStoreId(mdfName, mdfInterpretation, mdfLayout));
    }

    @Override
    public MongoPublisherStore getStoreFor(String targetMetadataPrefix) {
        MDFInfo info = this.configuration.getMetadataFormatInfo(targetMetadataPrefix);
        return this.getStore(info.getSourceFormatName(), info.getSourceFormatInterpretation(), info.getSourceFormatLayout());
    }

    @Override
    public MongoPublisherStore createStore(String mdfName, String mdfInterpretation, String mdfLayout) throws OaiPublisherException {
        DBObject store = this.createMetadataEntry(mdfName, mdfInterpretation, mdfLayout);
        DBCollection metadata = this.publisherDB.getCollection(this.metadataCollection);
        metadata.insert(new DBObject[]{store});
        return this.createFromDBObject(store);
    }

    @Override
    public boolean deleteStore(String storeId) {
        DBCollection metadata = this.publisherDB.getCollection(this.metadataCollection);
        DBObject storeInfo = metadata.findOne((DBObject)new BasicDBObject("id", (Object)storeId));
        if (storeInfo == null) {
            return false;
        }
        this.publisherDB.getCollection(storeId).drop();
        metadata.remove(storeInfo);
        return true;
    }

    @Override
    public boolean deleteStore(String mdfName, String mdfInterpretation, String mdfLayout) {
        return this.deleteStore(this.generateStoreId(mdfName, mdfInterpretation, mdfLayout));
    }

    private MongoPublisherStore createFromDBObject(DBObject storeInfo) {
        if (storeInfo == null) {
            return null;
        }
        String storeId = (String)storeInfo.get("id");
        String mdFormat = (String)storeInfo.get("metadataFormat");
        String mdInterpreation = (String)storeInfo.get("interpretation");
        String mdLayout = (String)storeInfo.get("layout");
        try {
            MongoPublisherStore store = new MongoPublisherStore(storeId, mdFormat, mdInterpreation, mdLayout, this.publisherDB.getCollection(storeId), (Multimap<String, String>)this.configuration.getIndices(mdFormat, mdInterpreation, mdLayout), this.queryParser, this.recordInfoGenerator, this.configuration.getIdScheme(), this.configuration.getIdNamespace(), this.metadataExtractor, this.recordChangeDetector);
            store.ensureIndices();
            return store;
        }
        catch (ISLookUpException e) {
            throw new OaiPublisherRuntimeException((Throwable)e);
        }
    }

    private DBObject createMetadataEntry(String mdfName, String mdfInterpretation, String mdfLayout) {
        DBObject info = BasicDBObjectBuilder.start((String)"id", (Object)this.generateStoreId(mdfName, mdfInterpretation, mdfLayout)).append("metadataFormat", (Object)mdfName).append("interpretation", (Object)mdfInterpretation).append("layout", (Object)mdfLayout).get();
        return info;
    }

    private String generateStoreId(String mdfName, String mdfInterpretation, String mdfLayout) {
        return mdfName + "-" + mdfInterpretation + "-" + mdfLayout;
    }

    public DB getPublisherDB() {
        return this.publisherDB;
    }

    public void setPublisherDB(DB publisherDB) {
        this.publisherDB = publisherDB;
    }

    public String getMetadataCollection() {
        return this.metadataCollection;
    }

    @Required
    public void setMetadataCollection(String metadataCollection) {
        this.metadataCollection = metadataCollection;
    }

    public MongoQueryParser getQueryParser() {
        return this.queryParser;
    }

    public void setQueryParser(MongoQueryParser queryParser) {
        this.queryParser = queryParser;
    }

    public PublisherConfigurationReader getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(PublisherConfigurationReader configuration) {
        this.configuration = configuration;
    }

    public RecordInfoGenerator getRecordInfoGenerator() {
        return this.recordInfoGenerator;
    }

    public void setRecordInfoGenerator(RecordInfoGenerator recordInfoGenerator) {
        this.recordInfoGenerator = recordInfoGenerator;
    }

    public MetadataExtractor getMetadataExtractor() {
        return this.metadataExtractor;
    }

    public void setMetadataExtractor(MetadataExtractor metadataExtractor) {
        this.metadataExtractor = metadataExtractor;
    }

    public RecordChangeDetector getRecordChangeDetector() {
        return this.recordChangeDetector;
    }

    public void setRecordChangeDetector(RecordChangeDetector recordChangeDetector) {
        this.recordChangeDetector = recordChangeDetector;
    }
}

