package eu.dnetlib.data.oai.store.conf;

import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;

/**
 * Updates counters for all sets related to the given metadata prefix.
 * <p>
 * It generates query to update the count, hence this task can be time consuming depending on the size of the OAI store.
 * </p>
 * 
 * @author alessia
 * 
 */
public class OAIStoreAllCounterUpdater extends Thread {

	private MDFInfo mdFormat;

	private OAISetCounterHelper oaiSetCounterHelper;

	@Override
	public void run() {
		this.oaiSetCounterHelper.updateAllCounts(mdFormat);
	}

	public OAIStoreAllCounterUpdater(final MDFInfo mdfInfo, final OAISetCounterHelper oaiSetCounterHelper) {
		this();
		this.mdFormat = mdfInfo;
		this.oaiSetCounterHelper = oaiSetCounterHelper;
	}

	public OAIStoreAllCounterUpdater() {
		super();
	}

	public MDFInfo getMdFormat() {
		return mdFormat;
	}

	public void setMdFormat(final MDFInfo mdFormat) {
		this.mdFormat = mdFormat;
	}

	public OAISetCounterHelper getOaiSetCounterHelper() {
		return oaiSetCounterHelper;
	}

	public void setOaiSetCounterHelper(final OAISetCounterHelper oaiSetCounterHelper) {
		this.oaiSetCounterHelper = oaiSetCounterHelper;
	}
}
