/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.conf;

import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationStringReader;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.oai.store.conf.OAISetCounterHelper;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStoreDAO;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OAIMdFormatUpdater
extends Thread {
    private static final Log log = LogFactory.getLog(OAIMdFormatUpdater.class);
    private OAIConfigurationStringReader configurationReader;
    private MongoPublisherStoreDAO mongoPublisherStoreDAO;
    private OAISetCounterHelper oaiSetCounterHelper;

    @Override
    public void run() {
        List metadataFormats = this.configurationReader.getMetadataFormatInfo();
        for (MDFInfo mdfInfo : metadataFormats) {
            log.info((Object)("Checking configuration for metadata prefix " + mdfInfo.getPrefix()));
            log.debug((Object)mdfInfo);
            MongoPublisherStore store = this.mongoPublisherStoreDAO.getStoreFor(mdfInfo.getPrefix());
            if (store == null) {
                log.debug((Object)("Creating store for metadata format: \n" + mdfInfo));
                try {
                    store = this.mongoPublisherStoreDAO.createStore(mdfInfo.getSourceFormatName(), mdfInfo.getSourceFormatInterpretation(), mdfInfo.getSourceFormatLayout());
                    log.debug((Object)("Created store with id: " + store.getId()));
                }
                catch (OaiPublisherException e) {
                    log.fatal((Object)("Can't prepare store for metadata prefix " + mdfInfo.getPrefix() + ". \nCause: " + e.getMessage()));
                }
            }
            log.debug((Object)("Updating counters for metadata prefix " + mdfInfo.getPrefix()));
            this.oaiSetCounterHelper.updateConfiguredSetOnly(mdfInfo);
            log.info((Object)("OAI Store ready for metadata prefix " + mdfInfo.getPrefix()));
        }
        log.info((Object)"All OAI stores are ready");
    }

    public OAIMdFormatUpdater(OAIConfigurationStringReader configurationReader, MongoPublisherStoreDAO mongoPublisherStoreDAO, OAISetCounterHelper oaiSetCounterHelper) {
        this.configurationReader = configurationReader;
        this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
        this.oaiSetCounterHelper = oaiSetCounterHelper;
    }

    public OAIMdFormatUpdater() {
    }

    public OAIConfigurationStringReader getConfigurationReader() {
        return this.configurationReader;
    }

    public void setConfigurationReader(OAIConfigurationStringReader configurationReader) {
        this.configurationReader = configurationReader;
    }

    public MongoPublisherStoreDAO getMongoPublisherStoreDAO() {
        return this.mongoPublisherStoreDAO;
    }

    public void setMongoPublisherStoreDAO(MongoPublisherStoreDAO mongoPublisherStoreDAO) {
        this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
    }

    public OAISetCounterHelper getOaiSetCounterHelper() {
        return this.oaiSetCounterHelper;
    }

    public void setOaiSetCounterHelper(OAISetCounterHelper oaiSetCounterHelper) {
        this.oaiSetCounterHelper = oaiSetCounterHelper;
    }
}

