/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.conf;

import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationStringReader;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.data.oai.store.conf.OAISetCounterHelper;
import eu.dnetlib.data.oai.store.sets.MongoSetCollection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OAISetUpdater
extends Thread {
    private static final Log log = LogFactory.getLog(OAISetUpdater.class);
    private OAIConfigurationStringReader configurationReader;
    private MongoSetCollection mongoSetCollection;
    private OAISetCounterHelper oaiSetCounterHelper;

    @Override
    public void run() {
        log.debug((Object)"*****Dropping and re-creating configuration sets******");
        this.mongoSetCollection.dropConfigurationSets();
        List oaiConfigSets = this.configurationReader.getSets();
        for (SetInfo setInfo : oaiConfigSets) {
            this.mongoSetCollection.upsertSet(setInfo, true);
        }
        List metadataFormats = this.configurationReader.getMetadataFormatInfo();
        for (MDFInfo mdFormat : metadataFormats) {
            this.oaiSetCounterHelper.updateConfiguredSetOnly(mdFormat);
        }
        log.info((Object)"Sets updated succesfully");
    }

    public OAISetUpdater() {
    }

    public OAISetUpdater(OAIConfigurationStringReader configurationReader, MongoSetCollection mongoSetCollection, OAISetCounterHelper oaiSetCounterHelper) {
        this.configurationReader = configurationReader;
        this.mongoSetCollection = mongoSetCollection;
        this.oaiSetCounterHelper = oaiSetCounterHelper;
    }

    public OAIConfigurationStringReader getConfigurationReader() {
        return this.configurationReader;
    }

    public void setConfigurationReader(OAIConfigurationStringReader configurationReader) {
        this.configurationReader = configurationReader;
    }

    public MongoSetCollection getMongoSetCollection() {
        return this.mongoSetCollection;
    }

    public void setMongoSetCollection(MongoSetCollection mongoSetCollection) {
        this.mongoSetCollection = mongoSetCollection;
    }

    public OAISetCounterHelper getOaiSetCounterHelper() {
        return this.oaiSetCounterHelper;
    }

    public void setOaiSetCounterHelper(OAISetCounterHelper oaiSetCounterHelper) {
        this.oaiSetCounterHelper = oaiSetCounterHelper;
    }
}

