/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.parser;

import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.functionality.index.parse.Relation;
import eu.dnetlib.functionality.index.parse.Relations;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.types.ObjectId;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.z3950.zing.cql.CQLAndNode;
import org.z3950.zing.cql.CQLBooleanNode;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLNotNode;
import org.z3950.zing.cql.CQLOrNode;
import org.z3950.zing.cql.CQLParseException;
import org.z3950.zing.cql.CQLParser;
import org.z3950.zing.cql.CQLTermNode;

public class MongoQueryParser {
    private static final Log log = LogFactory.getLog(MongoQueryParser.class);

    public DBObject parse(String query) {
        log.info((Object)("PARSING: " + query));
        if (StringUtils.isBlank((String)query)) {
            return new BasicDBObject();
        }
        DBObject parsed = this.toMongo(query);
        log.info((Object)parsed);
        return parsed;
    }

    private DBObject toMongo(String query) {
        CQLParser parser = new CQLParser();
        try {
            CQLNode root = parser.parse(query);
            return this.toMongo(root);
        }
        catch (CQLParseException e) {
            throw new OaiPublisherRuntimeException((Throwable)e);
        }
        catch (IOException e) {
            throw new OaiPublisherRuntimeException((Throwable)e);
        }
    }

    private DBObject toMongo(CQLNode node) {
        if (node instanceof CQLTermNode) {
            return this.doTranslate((CQLTermNode)node);
        }
        if (node instanceof CQLBooleanNode) {
            return this.doTranslate((CQLBooleanNode)node);
        }
        throw new RuntimeException("error choice for CQLNode " + node.getClass());
    }

    private DBObject doTranslate(CQLTermNode termNode) {
        if (termNode.getTerm().equals("*")) {
            return new BasicDBObject();
        }
        String relation = termNode.getRelation().getBase();
        Relation rel = Relations.get((String)relation);
        return this.handleRelationNode(rel, termNode);
    }

    private DBObject handleRelationNode(Relation rel, CQLTermNode termNode) {
        BasicDBObject mongoQueryObject = new BasicDBObject();
        String term = termNode.getTerm();
        String indexName = termNode.getIndex();
        String termObj = term;
        if (indexName.equals("_id")) {
            termObj = new ObjectId(term);
        } else if (indexName.equals("datestamp") || indexName.equals("lastCollectionDate")) {
            OAIDate termDate = this.parseDate(term);
            return this.handleDateRelationNode(indexName, rel, termDate);
        }
        switch (rel) {
            case EQUAL: 
            case EXACT: {
                mongoQueryObject.put(indexName, (Object)termObj);
                break;
            }
            case NOT: {
                mongoQueryObject.put(indexName, (Object)new BasicDBObject("$ne", (Object)termObj));
                break;
            }
            case GT: {
                mongoQueryObject.put(indexName, (Object)new BasicDBObject("$gt", (Object)termObj));
                break;
            }
            case GTE: {
                mongoQueryObject.put(indexName, (Object)new BasicDBObject("$gte", (Object)termObj));
                break;
            }
            case LT: {
                mongoQueryObject.put(indexName, (Object)new BasicDBObject("$lt", (Object)termObj));
                break;
            }
            case LTE: {
                mongoQueryObject.put(indexName, (Object)new BasicDBObject("$lte", (Object)termObj));
                break;
            }
            default: {
                throw new OaiPublisherRuntimeException("Can't parse query: relation " + rel + " not supported!");
            }
        }
        return mongoQueryObject;
    }

    private DBObject handleDateRelationNode(String indexName, Relation rel, OAIDate date) {
        BasicDBObject mongoQueryObject = new BasicDBObject();
        DateTime fromDate = date.date;
        switch (rel) {
            case EQUAL: 
            case EXACT: {
                if (date.onlyDate) {
                    DateTime endDate = date.date.plusDays(1);
                    mongoQueryObject.put(indexName, (Object)BasicDBObjectBuilder.start((String)"$gte", (Object)fromDate.toDate()).append("$lt", (Object)endDate.toDate()).get());
                    break;
                }
                DateTime endDate = date.date.plusSeconds(1);
                mongoQueryObject.put(indexName, (Object)BasicDBObjectBuilder.start((String)"$gte", (Object)fromDate.toDate()).append("$lt", (Object)endDate.toDate()).get());
                break;
            }
            case NOT: {
                mongoQueryObject.put(indexName, (Object)new BasicDBObject("$ne", (Object)fromDate.toDate()));
                break;
            }
            case GT: {
                mongoQueryObject.put(indexName, (Object)new BasicDBObject("$gt", (Object)fromDate.toDate()));
                break;
            }
            case GTE: {
                mongoQueryObject.put(indexName, (Object)new BasicDBObject("$gte", (Object)fromDate.toDate()));
                break;
            }
            case LT: {
                mongoQueryObject.put(indexName, (Object)new BasicDBObject("$lt", (Object)fromDate.toDate()));
                break;
            }
            case LTE: {
                mongoQueryObject.put(indexName, (Object)new BasicDBObject("$lte", (Object)fromDate.toDate()));
                break;
            }
            default: {
                throw new OaiPublisherRuntimeException("Can't parse query: relation " + rel + " not supported!");
            }
        }
        return mongoQueryObject;
    }

    private DBObject doTranslate(CQLBooleanNode node) {
        if (node instanceof CQLAndNode) {
            return this.getBooleanQuery("$and", node);
        }
        if (node instanceof CQLOrNode) {
            return this.getBooleanQuery("$or", node);
        }
        if (node instanceof CQLNotNode) {
            return this.getNotQuery((CQLNotNode)node);
        }
        throw new RuntimeException("error choice for CQLBooleanNode " + node.getClass());
    }

    private DBObject getBooleanQuery(String mongoOperator, CQLBooleanNode node) {
        DBObject left = this.toMongo(node.left);
        DBObject right = this.toMongo(node.right);
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList termList = Lists.newArrayList((Object[])new DBObject[]{left, right});
        andQuery.put(mongoOperator, (Object)termList);
        return andQuery;
    }

    private DBObject getNotQuery(CQLNotNode node) {
        DBObject left = this.toMongo(node.left);
        DBObject right = this.toMongo(node.right);
        BasicDBObject notRight = new BasicDBObject("$not", (Object)right);
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList termList = Lists.newArrayList((Object[])new DBObject[]{left, notRight});
        andQuery.put("$and", (Object)termList);
        return andQuery;
    }

    private OAIDate parseDate(String date) {
        DateTimeFormatter dateNoTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZoneUTC();
        DateTimeFormatter iso8601NoMsTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ").withZoneUTC();
        DateTimeFormatter iso8601Formatter = ISODateTimeFormat.dateTime().withZoneUTC();
        OAIDate res = null;
        try {
            log.debug((Object)("Using default " + iso8601Formatter.getClass()));
            DateTime dt = iso8601Formatter.parseDateTime(date);
            res = new OAIDate(dt, false);
        }
        catch (Exception e) {
            try {
                log.debug((Object)"Switching to ISO with no millisecond date formatter: yyyy-MM-dd'T'HH:mm:ssZ");
                DateTime dt = iso8601NoMsTimeFormatter.parseDateTime(date);
                res = new OAIDate(dt, false);
            }
            catch (Exception ex) {
                log.debug((Object)"Switching to simple date formatter: yyyy-MM-dd");
                DateTime dt = dateNoTimeFormatter.parseDateTime(date);
                res = new OAIDate(dt, true);
            }
        }
        return res;
    }

    class OAIDate {
        DateTime date;
        boolean onlyDate;

        OAIDate(DateTime date, boolean onlyDate) {
            this.date = date;
            this.onlyDate = onlyDate;
        }
    }
}

