package eu.dnetlib.data.oai.store.conf;

import javax.annotation.Resource;

import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationStringReader;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.enabling.actions.AbstractSubscriptionAction;

/**
 * When notified, it creates the stores as indicated in the confiuration profile.
 * 
 * @author alessia
 * 
 */
public class OAIMdFormatNotificationHandler extends AbstractSubscriptionAction {

	@Resource
	private OAIConfigurationStringReader configurationReader;
	@Resource
	private MongoPublisherStoreDAO mongoPublisherStoreDAO;
	@Resource
	private OAISetCounterHelper oaiSetCounterHelper;

	@Override
	public void notified(final String subscrId, final String topic, final String rsId, final String profile) {
		if (!topic.startsWith(getTopicPrefix()) || !isEnabled()) return;
		this.configurationReader.readConfiguration(profile);
		OAIMdFormatUpdater mdFormatUpdater = new OAIMdFormatUpdater(configurationReader, mongoPublisherStoreDAO, oaiSetCounterHelper);
		mdFormatUpdater.start();
	}

	public OAIConfigurationStringReader getConfigurationReader() {
		return configurationReader;
	}

	public void setConfigurationReader(final OAIConfigurationStringReader configurationReader) {
		this.configurationReader = configurationReader;
	}

}
