package eu.dnetlib.data.oai.store.conf;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationStringReader;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.data.oai.store.sets.MongoSetCollection;

/**
 * Updates the configuration and counters for the OAI sets configured via IS profile.
 * 
 * @author alessia
 * 
 */
public class OAISetUpdater extends Thread {

	private static final Log log = LogFactory.getLog(OAISetUpdater.class); // NOPMD by marko on 11/24/08 5:02 PM

	private OAIConfigurationStringReader configurationReader;
	private MongoSetCollection mongoSetCollection;
	private OAISetCounterHelper oaiSetCounterHelper;

	@Override
	public void run() {
		log.debug("*****Dropping and re-creating configuration sets******");
		this.mongoSetCollection.dropConfigurationSets();
		List<SetInfo> oaiConfigSets = this.configurationReader.getSets();
		for (SetInfo setInfo : oaiConfigSets) {
			this.mongoSetCollection.upsertSet(setInfo, true);
		}
		List<MDFInfo> metadataFormats = this.configurationReader.getMetadataFormatInfo();
		for (MDFInfo mdFormat : metadataFormats) {
			this.oaiSetCounterHelper.updateConfiguredSetOnly(mdFormat);
		}
		log.info("Sets updated succesfully");

	}

	public OAISetUpdater() {
		super();
		// TODO Auto-generated constructor stub
	}

	public OAISetUpdater(final OAIConfigurationStringReader configurationReader, final MongoSetCollection mongoSetCollection,
			final OAISetCounterHelper oaiSetCounterHelper) {
		super();
		this.configurationReader = configurationReader;
		this.mongoSetCollection = mongoSetCollection;
		this.oaiSetCounterHelper = oaiSetCounterHelper;
	}

	public OAIConfigurationStringReader getConfigurationReader() {
		return configurationReader;
	}

	public void setConfigurationReader(final OAIConfigurationStringReader configurationReader) {
		this.configurationReader = configurationReader;
	}

	public MongoSetCollection getMongoSetCollection() {
		return mongoSetCollection;
	}

	public void setMongoSetCollection(final MongoSetCollection mongoSetCollection) {
		this.mongoSetCollection = mongoSetCollection;
	}

	public OAISetCounterHelper getOaiSetCounterHelper() {
		return oaiSetCounterHelper;
	}

	public void setOaiSetCounterHelper(final OAISetCounterHelper oaiSetCounterHelper) {
		this.oaiSetCounterHelper = oaiSetCounterHelper;
	}

}
