/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.sync;

import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStoreDAO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class OAIStoreInitializer
implements Runnable {
    private static final Log log = LogFactory.getLog(OAIStoreInitializer.class);
    private MDFInfo mdfInfo;
    private MongoPublisherStoreDAO publisherStoreDAO;

    @Override
    public void run() {
        log.info((Object)("Checking configuration for metadata prefix " + this.mdfInfo.getPrefix()));
        log.debug((Object)this.mdfInfo);
        MongoPublisherStore store = this.publisherStoreDAO.getStoreFor(this.mdfInfo.getPrefix());
        if (store == null) {
            log.debug((Object)("Creating store for metadata format: \n" + this.mdfInfo));
            try {
                store = this.publisherStoreDAO.createStore(this.mdfInfo.getSourceFormatName(), this.mdfInfo.getSourceFormatInterpretation(), this.mdfInfo.getSourceFormatLayout());
                log.debug((Object)("Created store with id: " + store.getId()));
            }
            catch (OaiPublisherException e) {
                throw new OaiPublisherRuntimeException((Throwable)e);
            }
        }
        this.synchronizeContent(store);
    }

    protected abstract void synchronizeContent(MongoPublisherStore var1);

    public OAIStoreInitializer() {
    }

    public OAIStoreInitializer(MDFInfo mdfInfo, MongoPublisherStoreDAO publisherStoreDAO) {
        this.mdfInfo = mdfInfo;
        this.publisherStoreDAO = publisherStoreDAO;
    }

    public MDFInfo getMdfInfo() {
        return this.mdfInfo;
    }

    public void setMdfInfo(MDFInfo mdfInfo) {
        this.mdfInfo = mdfInfo;
    }

    public MongoPublisherStoreDAO getPublisherStoreDAO() {
        return this.publisherStoreDAO;
    }

    public void setPublisherStoreDAO(MongoPublisherStoreDAO publisherStoreDAO) {
        this.publisherStoreDAO = publisherStoreDAO;
    }
}

