/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.sync;

import com.google.common.collect.Lists;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationExistReader;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.oai.store.sync.OAIStoreInitializerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OAIStoreSynchronizer {
    private static final Log log = LogFactory.getLog(OAIStoreSynchronizer.class);
    @Resource
    private OAIConfigurationExistReader configuration;
    @Resource
    private OAIStoreInitializerFactory initializerFactory;
    private int maxInitThreads = 2;

    public void synchronize(final boolean forceContentSync, final Callable<?> callback, final Callable<?> failCallback) {
        log.info((Object)("Initializing OAI Publisher stores from its configuration profile with initializer from factory: " + this.initializerFactory.getClass().getCanonicalName()));
        if (forceContentSync) {
            log.info((Object)"Content will be synchronized as well.");
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    OAIStoreSynchronizer.this.checkStores(forceContentSync);
                }
                catch (InterruptedException e) {
                    log.error((Object)e);
                    OAIStoreSynchronizer.this.executeCallback(failCallback);
                }
                catch (ExecutionException e) {
                    log.error((Object)e);
                    OAIStoreSynchronizer.this.executeCallback(failCallback);
                }
                log.info((Object)"OAI Publisher configuration updated.");
                OAIStoreSynchronizer.this.executeCallback(callback);
            }
        }.start();
    }

    protected void checkStores(boolean forceContentSync) throws InterruptedException, ExecutionException {
        ExecutorService executor = Executors.newFixedThreadPool(this.maxInitThreads);
        List metadataFormats = this.configuration.getMetadataFormatInfo();
        ArrayList futures = Lists.newArrayList();
        for (MDFInfo mdf : metadataFormats) {
            futures.add(executor.submit(this.initializerFactory.create(mdf)));
        }
        executor.shutdown();
        for (Future future : futures) {
            future.get();
        }
    }

    protected void executeCallback(Callable<?> callback) {
        if (callback != null) {
            try {
                callback.call();
            }
            catch (Exception e) {
                log.error((Object)"Error executing callback", (Throwable)e);
            }
        }
    }

    public OAIConfigurationExistReader getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OAIConfigurationExistReader configuration) {
        this.configuration = configuration;
    }

    public OAIStoreInitializerFactory getInitializerFactory() {
        return this.initializerFactory;
    }

    public void setInitializerFactory(OAIStoreInitializerFactory initializerFactory) {
        this.initializerFactory = initializerFactory;
    }

    public int getMaxInitThreads() {
        return this.maxInitThreads;
    }

    public void setMaxInitThreads(int maxInitThreads) {
        this.maxInitThreads = maxInitThreads;
    }
}

