/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.mongo;

import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationReader;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.oai.store.PublisherStoreDAO;
import eu.dnetlib.data.oai.store.RecordChangeDetector;
import eu.dnetlib.data.oai.store.mongo.MetadataExtractor;
import eu.dnetlib.data.oai.store.mongo.MongoCursor;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.mongo.RecordInfoGenerator;
import eu.dnetlib.data.oai.store.parser.MongoQueryParser;
import eu.dnetlib.data.oai.store.sets.MongoSetCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Required;

public class MongoPublisherStoreDAO
implements PublisherStoreDAO<MongoPublisherStore, MongoCursor> {
    private String metadataCollection;
    @Resource(name="publisherMongoDB")
    private DB publisherDB;
    @Resource
    private RecordInfoGenerator recordInfoGenerator;
    @Resource
    private MetadataExtractor metadataExtractor;
    @Resource
    private MongoQueryParser queryParser;
    @Resource(name="oaiConfigurationExistReader")
    private OAIConfigurationReader configuration;
    @Resource
    private RecordChangeDetector recordChangeDetector;
    @Resource
    private MongoSetCollection mongoSetCollection;
    private boolean patch = false;

    @Override
    public List<MongoPublisherStore> listPublisherStores() {
        ArrayList stores = Lists.newArrayList();
        DBCursor cursor = this.publisherDB.getCollection(this.metadataCollection).find();
        for (DBObject storeInfo : cursor) {
            stores.add(this.createFromDBObject(storeInfo));
        }
        return stores;
    }

    @Override
    public MongoPublisherStore getStore(String storeId) {
        DBObject storeInfo = this.publisherDB.getCollection(this.metadataCollection).findOne((DBObject)new BasicDBObject("id", (Object)storeId));
        return this.createFromDBObject(storeInfo);
    }

    @Override
    public MongoPublisherStore getStore(String mdfName, String mdfInterpretation, String mdfLayout) {
        return this.getStore(this.generateStoreId(mdfName, mdfInterpretation, mdfLayout));
    }

    @Override
    public MongoPublisherStore getStoreFor(String targetMetadataPrefix) {
        MDFInfo info = this.configuration.getMetadataFormatInfo(targetMetadataPrefix);
        return this.getStore(info.getSourceFormatName(), info.getSourceFormatInterpretation(), info.getSourceFormatLayout());
    }

    @Override
    public MongoPublisherStore createStore(String mdfName, String mdfInterpretation, String mdfLayout) throws OaiPublisherException {
        DBObject store = this.createMetadataEntry(mdfName, mdfInterpretation, mdfLayout);
        DBCollection metadata = this.publisherDB.getCollection(this.metadataCollection);
        metadata.insert(new DBObject[]{store});
        MongoPublisherStore theStore = this.createFromDBObject(store);
        theStore.ensureIndices();
        return theStore;
    }

    @Override
    public boolean deleteStore(String storeId) {
        DBCollection metadata = this.publisherDB.getCollection(this.metadataCollection);
        DBObject storeInfo = metadata.findOne((DBObject)new BasicDBObject("id", (Object)storeId));
        if (storeInfo == null) {
            return false;
        }
        this.publisherDB.getCollection(storeId).drop();
        metadata.remove(storeInfo);
        return true;
    }

    @Override
    public boolean deleteStore(String mdfName, String mdfInterpretation, String mdfLayout) {
        return this.deleteStore(this.generateStoreId(mdfName, mdfInterpretation, mdfLayout));
    }

    public void ensureIndex(final MongoPublisherStore store) {
        if (store == null) {
            throw new OaiPublisherRuntimeException("Can't ensure index on null store");
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                store.ensureIndices();
            }
        };
        t.start();
    }

    public void ensureIndex() {
        this.ensureIndex(1);
    }

    public void ensureIndex(int maxThreads) {
        ExecutorService executorService = Executors.newFixedThreadPool(maxThreads);
        List<MongoPublisherStore> stores = this.listPublisherStores();
        for (final MongoPublisherStore s : stores) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    s.ensureIndices();
                }
            });
        }
        executorService.shutdown();
    }

    private MongoPublisherStore createFromDBObject(DBObject storeInfo) {
        if (storeInfo == null) {
            return null;
        }
        String storeId = (String)storeInfo.get("id");
        String mdFormat = (String)storeInfo.get("metadataFormat");
        String mdInterpreation = (String)storeInfo.get("interpretation");
        String mdLayout = (String)storeInfo.get("layout");
        MongoPublisherStore store = new MongoPublisherStore(storeId, mdFormat, mdInterpreation, mdLayout, this.publisherDB.getCollection(storeId), this.configuration.getFields(mdFormat, mdInterpreation, mdLayout), this.queryParser, this.recordInfoGenerator, this.configuration.getIdScheme(), this.configuration.getIdNamespace(), this.metadataExtractor, this.recordChangeDetector);
        store.setMongoSetCollection(this.mongoSetCollection);
        store.setPatch(this.patch);
        return store;
    }

    private DBObject createMetadataEntry(String mdfName, String mdfInterpretation, String mdfLayout) {
        DBObject info = BasicDBObjectBuilder.start((String)"id", (Object)this.generateStoreId(mdfName, mdfInterpretation, mdfLayout)).append("metadataFormat", (Object)mdfName).append("interpretation", (Object)mdfInterpretation).append("layout", (Object)mdfLayout).get();
        return info;
    }

    private String generateStoreId(String mdfName, String mdfInterpretation, String mdfLayout) {
        return mdfName + "-" + mdfInterpretation + "-" + mdfLayout;
    }

    public DB getPublisherDB() {
        return this.publisherDB;
    }

    public void setPublisherDB(DB publisherDB) {
        this.publisherDB = publisherDB;
    }

    public String getMetadataCollection() {
        return this.metadataCollection;
    }

    @Required
    public void setMetadataCollection(String metadataCollection) {
        this.metadataCollection = metadataCollection;
    }

    public MongoQueryParser getQueryParser() {
        return this.queryParser;
    }

    public void setQueryParser(MongoQueryParser queryParser) {
        this.queryParser = queryParser;
    }

    public OAIConfigurationReader getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OAIConfigurationReader configuration) {
        this.configuration = configuration;
    }

    public RecordInfoGenerator getRecordInfoGenerator() {
        return this.recordInfoGenerator;
    }

    public void setRecordInfoGenerator(RecordInfoGenerator recordInfoGenerator) {
        this.recordInfoGenerator = recordInfoGenerator;
    }

    public MetadataExtractor getMetadataExtractor() {
        return this.metadataExtractor;
    }

    public void setMetadataExtractor(MetadataExtractor metadataExtractor) {
        this.metadataExtractor = metadataExtractor;
    }

    public RecordChangeDetector getRecordChangeDetector() {
        return this.recordChangeDetector;
    }

    public void setRecordChangeDetector(RecordChangeDetector recordChangeDetector) {
        this.recordChangeDetector = recordChangeDetector;
    }

    public MongoSetCollection getMongoSetCollection() {
        return this.mongoSetCollection;
    }

    public void setMongoSetCollection(MongoSetCollection mongoSetCollection) {
        this.mongoSetCollection = mongoSetCollection;
    }

    public boolean isPatch() {
        return this.patch;
    }

    public void setPatch(boolean patch) {
        this.patch = patch;
    }
}

