/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.conf;

import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationReader;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.data.oai.store.sets.MongoSetCollection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OAISetHelper {
    private static final Log log = LogFactory.getLog(OAISetHelper.class);
    @Resource(name="oaiConfigurationExistReader")
    private OAIConfigurationReader configurationReader;
    @Resource
    private MongoPublisherStoreDAO mongoPublisherStoreDAO;
    @Resource
    private MongoSetCollection mongoSetCollection;

    public void updateAllCounts(MDFInfo mdFormat) {
        this.updateTotalCount(mdFormat);
        List<SetInfo> sets = this.mongoSetCollection.getAllSets();
        this.updateCountForSets(sets, mdFormat);
    }

    public void updateConfiguredSetsCount(MDFInfo mdFormat) {
        this.updateTotalCount(mdFormat);
        List<SetInfo> sets = this.mongoSetCollection.getConfiguredSets();
        this.updateCountForSets(sets, mdFormat);
    }

    protected void updateTotalCount(MDFInfo mdFormat) {
        log.info((Object)"Ensuring indices on OAI sets mongo collection . . .");
        this.mongoSetCollection.ensureIndexes();
        String format = mdFormat.getSourceFormatName();
        String layout = mdFormat.getSourceFormatLayout();
        String interpretation = mdFormat.getSourceFormatInterpretation();
        String sourceKey = format + "-" + layout + "-" + interpretation;
        log.info((Object)("Updating count for OAI store " + sourceKey + " via metadata prefix " + mdFormat.getPrefix()));
        log.debug((Object)mdFormat);
        MongoPublisherStore store = this.mongoPublisherStoreDAO.getStoreFor(mdFormat.getPrefix());
        if (store == null) {
            log.info((Object)("Can't count elements for not yet created store (" + mdFormat + ")."));
        } else {
            String baseQuery = mdFormat.getBaseQuery();
            log.info((Object)("Counting total for " + mdFormat.getPrefix() + " with query: " + baseQuery));
            int total = store.count(baseQuery);
            this.mongoSetCollection.updateCounts("ALL", mdFormat.getPrefix(), total);
            log.info((Object)("Counts updated for " + mdFormat.getPrefix()));
        }
    }

    protected void updateCountForSets(List<SetInfo> oaiSets, MDFInfo mdFormat) {
        MongoPublisherStore store = this.mongoPublisherStoreDAO.getStoreFor(mdFormat.getPrefix());
        if (store == null) {
            log.info((Object)("Can't count elements for not yet created store (" + mdFormat + ")."));
        } else {
            String baseQuery = mdFormat.getBaseQuery();
            boolean hasBaseQuery = !StringUtils.isBlank((String)baseQuery);
            for (SetInfo setInfo : oaiSets) {
                String setQuery = setInfo.getQuery();
                if (hasBaseQuery) {
                    setQuery = setQuery + " AND " + baseQuery;
                }
                log.info((Object)("Counting total for " + mdFormat.getPrefix() + " set " + setInfo + " with query: " + setQuery));
                int setCount = store.count(setQuery);
                this.mongoSetCollection.updateCounts(setInfo.getSetSpec(), mdFormat.getPrefix(), setCount);
            }
        }
    }

    public void updateSetsFromConfig(OAIConfigurationReader configReader) {
        log.debug((Object)"*****Dropping and re-creating configuration sets******");
        this.mongoSetCollection.dropConfigurationSets();
        List oaiConfigSets = configReader.getSets();
        for (SetInfo setInfo : oaiConfigSets) {
            this.mongoSetCollection.upsertSet(setInfo, true);
        }
        List metadataFormats = configReader.getMetadataFormatInfo();
        for (MDFInfo mdFormat : metadataFormats) {
            this.updateConfiguredSetsCount(mdFormat);
        }
        log.info((Object)"Sets updated succesfully");
    }

    public void updateSetsFromConfig() {
        this.updateSetsFromConfig(this.configurationReader);
    }

    public void updateSetsFromConfig(Callable<?> callback, Callable<?> failCallback) {
        try {
            this.updateSetsFromConfig(this.configurationReader);
            this.executeCallback(callback);
        }
        catch (Exception e) {
            log.error((Object)e);
            this.executeCallback(failCallback);
        }
    }

    protected void executeCallback(Callable<?> callback) {
        if (callback != null) {
            try {
                callback.call();
            }
            catch (Exception e) {
                log.error((Object)"Error executing callback", (Throwable)e);
            }
        }
    }

    public OAIConfigurationReader getConfigurationReader() {
        return this.configurationReader;
    }

    public void setConfigurationReader(OAIConfigurationReader configurationReader) {
        this.configurationReader = configurationReader;
    }

    public MongoPublisherStoreDAO getMongoPublisherStoreDAO() {
        return this.mongoPublisherStoreDAO;
    }

    public void setMongoPublisherStoreDAO(MongoPublisherStoreDAO mongoPublisherStoreDAO) {
        this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
    }

    public MongoSetCollection getMongoSetCollection() {
        return this.mongoSetCollection;
    }

    public void setMongoSetCollection(MongoSetCollection mongoSetCollection) {
        this.mongoSetCollection = mongoSetCollection;
    }
}

