package eu.dnetlib.data.oai.store.actions;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class EnsureIndexesAction extends AbstractOAIStoreAction {

	private static final Log log = LogFactory.getLog(EnsureIndexesAction.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Resource
	private MongoPublisherStoreDAO mongoPublisherStoreDAO;
	private int max_threads = 1;

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
		try {
			String mdPrefix = job.getParameters().get("ensure_mdPrefix");
			if (StringUtils.isBlank(mdPrefix)) {
				log.info("ensuring index on all OAI store");
				this.mongoPublisherStoreDAO.ensureIndex(max_threads);
			} else {
				log.info("ensuring index on " + mdPrefix + " only");
				MongoPublisherStore store = this.mongoPublisherStoreDAO.getStoreFor(mdPrefix);
				store.ensureIndices();
			}
			handler.done(job);
		} catch (Exception e) {
			handler.failed(job, e);
		}
	}

	public MongoPublisherStoreDAO getMongoPublisherStoreDAO() {
		return mongoPublisherStoreDAO;
	}

	public void setMongoPublisherStoreDAO(final MongoPublisherStoreDAO mongoPublisherStoreDAO) {
		this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
	}

	public int getMax_threads() {
		return max_threads;
	}

	public void setMax_threads(final int max_threads) {
		this.max_threads = max_threads;
	}

}
