package eu.dnetlib.data.oai.store.actions;

import java.util.concurrent.Callable;

import javax.annotation.Resource;

import eu.dnetlib.data.oai.store.conf.OAISetsCounter;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class CountSetsAction extends AbstractOAIStoreAction {

	@Resource
	private OAISetsCounter setsCounter;

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
		this.setsCounter.updateCounts(new Callable<Object>() {

			@Override
			public Object call() {
				handler.done(job);
				return null;
			}
		}, new Callable<Object>() {

			@Override
			public Object call() {
				handler.failed(job, new Exception("Error during OAI sets count"));
				return null;
			}
		});

	}

	public OAISetsCounter getSetsCountUpdater() {
		return setsCounter;
	}

	public void setSetsCountUpdater(final OAISetsCounter setsCountUpdater) {
		this.setsCounter = setsCountUpdater;
	}

}
