package eu.dnetlib.data.oai.store.actions;

import java.util.concurrent.Callable;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.oai.store.sync.OAIStoreSynchronizer;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class SyncAction extends AbstractOAIStoreAction {

	private static final Log log = LogFactory.getLog(SyncAction.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Resource
	private OAIStoreSynchronizer synchronizer;
	@Resource
	private ResultSetClientFactory resultSetClientFactory;

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
		log.fatal("I am " + this.getClass() + ", in execute method");
		EPRUtils eprUtils = new EPRUtils();
		W3CEndpointReference epr = eprUtils.getEpr(job.getParameters().get("oai_syncEpr"));
		String recordSource = job.getParameters().get("oai_recordSource");
		String formatName = job.getParameters().get("oai_formatName");
		String formatLayout = job.getParameters().get("oai_formatLayout");
		String formatInterpretation = job.getParameters().get("oai_formatInterpretation");
		MDFInfo mdf = new MDFInfo("", "", "", formatName, formatLayout, formatInterpretation, "", true);
		IterableResultSetClient client = resultSetClientFactory.getClient(epr);

		this.synchronizer.synchronize(client, mdf, recordSource, new Callable<Object>() {

			@Override
			public Object call() {
				handler.done(job);
				return null;
			}
		}, new Callable<Object>() {

			@Override
			public Object call() {
				handler.failed(job, new Exception("Error during OAI synchronization"));
				return null;
			}
		});

	}

	public OAIStoreSynchronizer getSynchronizer() {
		return synchronizer;
	}

	public void setSynchronizer(final OAIStoreSynchronizer synchronizer) {
		this.synchronizer = synchronizer;
	}

	public ResultSetClientFactory getRsClientFactory() {
		return resultSetClientFactory;
	}

	public void setRsClientFactory(final ResultSetClientFactory rsClientFactory) {
		this.resultSetClientFactory = rsClientFactory;
	}

}
