package eu.dnetlib.data.oai.store.conf;

import java.util.List;
import java.util.concurrent.Callable;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationReader;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.oai.store.sets.MongoSetCollection;

/**
 * Updates the counts for all sets in the special sets collection of OAI store.
 * 
 * @author alessia
 * 
 */
public class OAISetsCounter {

	private static final Log log = LogFactory.getLog(OAISetsCounter.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Resource(name = "oaiConfigurationExistReader")
	private OAIConfigurationReader configurationReader;
	@Resource
	private MongoSetCollection mongoSetCollection;
	@Resource
	private OAISetHelper oaiSetHelper;

	/**
	 * Update counts for all OAI sets and all md formats.
	 * 
	 * @param callback
	 *            callback to execute when the execution is successfull
	 * @param failCallbackcallback
	 *            to execute when the execution fails
	 */
	public void updateCounts(final Callable<?> callback, final Callable<?> failCallback) {
		new Thread() {

			@Override
			public void run() {
				try {
					List<MDFInfo> metadataFormats = configurationReader.getMetadataFormatInfo();
					for (MDFInfo mdFormat : metadataFormats) {
						oaiSetHelper.updateAllCounts(mdFormat);
					}
					log.info("All sets count updated succesfully");
					executeCallback(callback);
				} catch (Exception e) {
					log.error(e);
					executeCallback(failCallback);
				}
			}
		}.start();
	}

	public void updateCounts(final MDFInfo mdf, final Callable<?> callback, final Callable<?> failCallback) {
		new Thread() {

			@Override
			public void run() {
				try {
					oaiSetHelper.updateAllCounts(mdf);
					log.info("All sets count updated succesfully for metadata format " + mdf);
					executeCallback(callback);
				} catch (Exception e) {
					log.error(e);
					executeCallback(failCallback);
				}
			}
		}.start();
	}

	protected void executeCallback(final Callable<?> callback) {
		if (callback != null) {
			try {
				callback.call();
			} catch (Exception e) {
				log.error("Error executing callback", e);
			}
		}
	}

	public OAIConfigurationReader getConfigurationReader() {
		return configurationReader;
	}

	public void setConfigurationReader(final OAIConfigurationReader configurationReader) {
		this.configurationReader = configurationReader;
	}

	public MongoSetCollection getMongoSetCollection() {
		return mongoSetCollection;
	}

	public void setMongoSetCollection(final MongoSetCollection mongoSetCollection) {
		this.mongoSetCollection = mongoSetCollection;
	}

	public OAISetHelper getOaiSetCounterHelper() {
		return oaiSetHelper;
	}

	public void setOaiSetCounterHelper(final OAISetHelper oaiSetHelper) {
		this.oaiSetHelper = oaiSetHelper;
	}

}
