package eu.dnetlib.data.oai.store.mongo;

import java.io.StringReader;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

import com.google.common.collect.Sets;
import com.mongodb.DBObject;

import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationReader;
import eu.dnetlib.data.information.oai.publisher.info.RecordInfo;

/**
 * Helper class to generate a RecordInfo object from a Mongo DBObject.
 * 
 * @author alessia
 * 
 */
public class RecordInfoGenerator {

	@Resource
	private MetadataExtractor metadataExtractor;

	@SuppressWarnings("unchecked")
	public RecordInfo transformDBObject(final DBObject object, final boolean includeBody) {
		String id = (String) object.get(OAIConfigurationReader.ID_FIELD);
		// need to escape the identifier, otherwise the XML breaks
		id = StringEscapeUtils.escapeXml(id);
		boolean deleted = (Boolean) object.get("deleted");
		RecordInfo record = new RecordInfo();
		record.setIdentifier(id);
		record.setInternalId(object.get("_id").toString());
		record.setDatestamp((Date) object.get(OAIConfigurationReader.DATESTAMP_FIELD));
		record.setDeleted(deleted);
		List<String> sets = (List<String>) object.get(OAIConfigurationReader.SET_FIELD);
		if (sets != null) {
			record.setSetspecs(Sets.newHashSet(sets));
		}
		if (includeBody && !deleted) {
			String body = (String) object.get(OAIConfigurationReader.BODY_FIELD);
			final SAXReader reader = new SAXReader();
			Document doc;
			try {
				doc = reader.read(new StringReader(body));
				record.setMetadata(this.metadataExtractor.evaluate(doc));

			} catch (DocumentException e) {
				throw new OaiPublisherRuntimeException(e);
			}
		}
		return record;

	}

	public MetadataExtractor getMetadataExtractor() {
		return metadataExtractor;
	}

	public void setMetadataExtractor(final MetadataExtractor metadataExtractor) {
		this.metadataExtractor = metadataExtractor;
	}

}
