/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.oai.store.actions;

import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.oai.store.actions.AbstractOAIStoreAction;
import eu.dnetlib.data.oai.store.sync.OAIStoreSynchronizer;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SyncAction
extends AbstractOAIStoreAction {
    private static final Log log = LogFactory.getLog(SyncAction.class);
    @Resource
    private OAIStoreSynchronizer synchronizer;
    @Resource
    private ResultSetClientFactory resultSetClientFactory;

    public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
        log.fatal((Object)("I am " + this.getClass() + ", in execute method"));
        EPRUtils eprUtils = new EPRUtils();
        W3CEndpointReference epr = eprUtils.getEpr((String)job.getParameters().get("oai_syncEpr"));
        String recordSource = (String)job.getParameters().get("oai_recordSource");
        String formatName = (String)job.getParameters().get("oai_formatName");
        String formatLayout = (String)job.getParameters().get("oai_formatLayout");
        String formatInterpretation = (String)job.getParameters().get("oai_formatInterpretation");
        MDFInfo mdf = new MDFInfo("", "", "", formatName, formatLayout, formatInterpretation, "", true);
        IterableResultSetClient client = this.resultSetClientFactory.getClient(epr);
        this.synchronizer.synchronize((Iterable<String>)client, mdf, recordSource, new Callable<Object>(){

            @Override
            public Object call() {
                handler.done(job);
                return null;
            }
        }, new Callable<Object>(){

            @Override
            public Object call() {
                handler.failed(job, (Throwable)new Exception("Error during OAI synchronization"));
                return null;
            }
        });
    }

    public OAIStoreSynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public void setSynchronizer(OAIStoreSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    public ResultSetClientFactory getRsClientFactory() {
        return this.resultSetClientFactory;
    }

    public void setRsClientFactory(ResultSetClientFactory rsClientFactory) {
        this.resultSetClientFactory = rsClientFactory;
    }
}

