package eu.dnetlib.data.transform;

import java.io.StringReader;

import javax.xml.transform.TransformerFactory;

import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;

public class XsltRowTransformerFactory {

	public XsltRowTransformer getTransformer(final String xslt) {
		try {
			if ((xslt == null) || xslt.isEmpty()) { return new XsltRowTransformer(null); }

			return new XsltRowTransformer(TransformerFactory.newInstance().newTransformer(new DocumentSource(new SAXReader().read(new StringReader(xslt)))));
		} catch (Exception e) {
			throw new RuntimeException("Error generating transformer from xslt:\n" + xslt, e);
		}
	}
}
