package eu.dnetlib.data.transform.xml;

import org.w3c.dom.NodeList;

public class DNetMdStoreToHbaseXsltFunctions extends DmfToHbaseXsltFunctions {

	public static final String DEFAULT_TRUST = "0.9";
	public static final String DEFAULT_PROVENANCE = "sysimport:crosswalk:repository";

	//dnet:oafPersonResultFromMDStore($resultId, $oafPerson, position())
	public static String oafPersonResultFromMDStore(final String personId, final String resultId, final int rank) {
		return oafPersonResultFromDMF(personId, resultId, rank, DEFAULT_PROVENANCE, DEFAULT_TRUST);
	}
	
	//dnet:oafPersonResultFromMDStore($resultId, $oafPerson, position())
	public static String oafPersonPersonFromMDStore(final String source, final String target) {
		return oafPersonPersonFromDMF(source, target, DEFAULT_PROVENANCE, DEFAULT_TRUST);
	}	

	//dnet:oafResultProjectFromMDStore($resultId, $projectId)
	public static String oafResultProjectFromMDStore(final String sourceId, final String targetId) {
		return oafResultProjectFromDMF(sourceId, targetId, DEFAULT_PROVENANCE, DEFAULT_TRUST);
	}

	//dnet:oafPersonFromMDStore($personId, .)
	public static String oafPersonFromMDStore(
			final String personId,
			final String collectedFromId,
			final String collectedFromName,
			final String originalId,
			final String dateOfCollection,
			final String fullname) {
		return oafPersonFromDMF(personId, fullname, DEFAULT_PROVENANCE, DEFAULT_TRUST, collectedFromId, collectedFromName, originalId, dateOfCollection);
	}

	public static String oafResultFromMDStore(
			final String resultId,
			final String hostedbyId, 
			final String hostedbyName,
			final String collectedFromId,
			final String collectedFromName,
			final String originalId,
			final String dateOfCollection,
			final NodeList nodelist) {
		return oafResultFromDMF(resultId, DEFAULT_PROVENANCE, DEFAULT_TRUST, hostedbyId, hostedbyName, collectedFromId, collectedFromName, originalId, dateOfCollection, nodelist);
	}

}
