package eu.dnetlib.data.transform.xml;

import java.util.List;
import java.util.Map;

import org.w3c.dom.NodeList;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors.Descriptor;

import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.OafProtos.OafRel;
import eu.dnetlib.data.proto.PersonPersonProtos.PersonPerson;
import eu.dnetlib.data.proto.PersonProtos.Person;
import eu.dnetlib.data.proto.PersonResultProtos.PersonResult;
import eu.dnetlib.data.proto.RelMetadataProtos.RelMetadata;
import eu.dnetlib.data.proto.RelTypeProtos.RelType;
import eu.dnetlib.data.proto.ResultProjectProtos.ResultProject;
import eu.dnetlib.data.proto.ResultProtos.Result;
import eu.dnetlib.data.proto.ResultProtos.Result.ExternalReference;
import eu.dnetlib.data.proto.ResultProtos.Result.Instance;
import eu.dnetlib.data.proto.ResultProtos.Result.Journal;
import eu.dnetlib.data.proto.StructuredPropertyProtos.StructuredProperty;
import eu.dnetlib.data.proto.TypeProtos.Type;

public class DmfToHbaseXsltFunctions extends AbstractDNetOafXsltFunctions {

	//dnet:oafPersonResultFromDMF($resultId, $oafPerson, position(), "sysimport:crosswalk:repository", "0.9")
	public static String oafPersonResultFromDMF(
			final String personId,
			final String resultId,
			final int rank,
			final String provenanceAction,
			final String trust) {
		try {
			final PersonResult.Builder pr = PersonResult.newBuilder().setRanking("" + rank);

			RelMetadata.Builder metadata = RelMetadata.newBuilder().setSemantics(getSimpleQualifier("author", "dnet:personroles"));
			OafRel.Builder rel = getRel(personId, resultId, RelType.personResult, false).setPersonResult(pr.setRelMetadata(metadata));

			return base64(getOaf(rel, getDataInfo(provenanceAction, trust, false, false)).toByteArray());
		} catch (Exception e) {
			System.err.println(e.getMessage());
			throw new RuntimeException(e);
		}
	}

	//dnet:oafPersonPersonFromMDStore($personId, $coauthorId)
	public static String oafPersonPersonFromDMF(final String source, final String target, final String provenanceAction, final String trust) {
		try {
			final PersonPerson.Builder pp = PersonPerson.newBuilder();

			RelMetadata.Builder metadata = RelMetadata.newBuilder().setSemantics(getSimpleQualifier("coauthor", "dnet:personroles"));
			OafRel.Builder rel = getRel(source, target, RelType.personPerson, false).setPersonPerson(pp.setRelMetadata(metadata));

			return base64(getOaf(rel, getDataInfo(provenanceAction, trust, false, false)).toByteArray());
		} catch (Exception e) {
			System.err.println(e.getMessage());
			throw new RuntimeException(e);
		}
	}

	//dnet:oafPersonFromDMF($personId, ., "sysimport:crosswalk:repository", "0.9")
	public static String oafPersonFromDMF(
			final String personId,
			final String fullname,
			final String provenanceAction,
			final String trust,
			final String collectedFromId,
			final String collectedFromName,
			final String originalId,
			final String dateOfCollection) {
		try {

			final Person.Builder person = Person.newBuilder();
			final Person.Metadata.Builder metadata = Person.Metadata.newBuilder();

			metadata.setFullname(fullname);

			eu.dnetlib.pace.model.Person p = new eu.dnetlib.pace.model.Person(fullname);
			if (p.isAccurate()) {
				metadata.setFirstname(Joiner.on(" ").join(p.getName()));
				metadata.clearSecondnames().addAllSecondnames(p.getSurname());
				metadata.setFullname(p.getNormalisedFullname());
			}

			//metadata.setNationality(getSimpleQualifier("UNKNOWN", "dnet:countries"));
			List<StructuredProperty> pids = Lists.newArrayList();
			OafEntity.Builder entity = getEntity(Type.person, personId, getKV(collectedFromId, collectedFromName), originalId, dateOfCollection, pids)
					.setPerson(person.setMetadata(metadata));

			return base64(getOaf(entity, getDataInfo(provenanceAction, trust, false, false)).toByteArray());
		} catch (Exception e) {
			System.err.println(e.getMessage());
			throw new RuntimeException(e);
		}
	}

	//dnet:oafResultProjectFromDMF($resultId, $projectId, "sysimport:crosswalk:repository", "0.9")
	public static String oafResultProjectFromDMF(final String sourceId, final String targetId, final String provenanceAction, final String trust) {
		try {
			final ResultProject.Builder rp = ResultProject.newBuilder();

			RelMetadata.Builder metadata = RelMetadata.newBuilder().setSemantics(getSimpleQualifier("isResultOf", "dnet:result_project_relations"));
			OafRel.Builder rel = getRel(sourceId, targetId, RelType.resultProject, false).setResultProject(rp.setRelMetadata(metadata));

			return base64(getOaf(rel, getDataInfo(provenanceAction, trust, false, false)).toByteArray());
		} catch (Exception e) {
			System.err.println(e.getMessage());
			throw new RuntimeException(e);
		}
	}

	public static String oafResultFromDMF(
			final String resultId,
			final String provenanceAction,
			final String trust,
			final String hostedbyId,
			final String hostedbyName,
			final String collectedFromId,
			final String collectedFromName,
			final String originalId,
			final String dateOfCollection,
			final NodeList nodelist) {
		try {
			final Result.Builder result = Result.newBuilder();

			final ValueMap values = parseNodeList(nodelist);

			final Result.Metadata.Builder metadata = Result.Metadata.newBuilder();
			final Descriptor mDesc = Result.Metadata.getDescriptor();

			addStructuredProps(metadata, mDesc.findFieldByName("subject"), values.get("subject").listValues(), "keyword", "dnet:result_subject");
			addStructuredProps(metadata, mDesc.findFieldByName("title"), values.get("title").listValues(), "main title", "dnet:dataCite_title");

			for (String fieldname : Lists.newArrayList("description", "source")) {
				if (values.get(fieldname) != null) {
					for (String s : values.get(fieldname).listValues()) {
						addField(metadata, mDesc.findFieldByName(fieldname), s);
					}
				}
			}

			addField(metadata, mDesc.findFieldByName("language"),
					setQualifier(getDefaultQualifier("dnet:languages"), values.get("language").listValues(), "und", "Undetermined").build());
			addField(metadata, mDesc.findFieldByName("dateofacceptance"), values.get("dateaccepted").listValues());
			addField(metadata, mDesc.findFieldByName("publisher"), values.get("publisher").listValues());
			addField(metadata, mDesc.findFieldByName("embargoenddate"), values.get("embargoenddate").listValues());
			addField(metadata, mDesc.findFieldByName("storagedate"), values.get("storagedate").listValues());

			addField(metadata, mDesc.findFieldByName("resulttype"), getSimpleQualifier("publication", "dnet:result_typologies").build());

			addField(metadata, mDesc.findFieldByName("fulltext"), values.get("fulltext").listValues());

			//			addField(metadata, Result.Metadata.getDescriptor().findFieldByName("provenanceaction"),
			//					getSimpleQualifier("sysimport:crosswalk:repository", "dnet:provenanceActions").build());

			if (values.get("journal") != null) {
				for (Element e : values.get("journal")) {

					final Journal.Builder journal = Journal.newBuilder();
					if (e.getText() != null) {
						journal.setName(e.getText());
					}

					final Map<String, String> attr = e.getAttributes();
					if (attr != null) {
						if (attr.get("issn") != null) {
							journal.setIssnPrinted(attr.get("issn"));
						}
						if (attr.get("eissn") != null) {
							journal.setIssnOnline(attr.get("eissn"));
						}
						if (attr.get("lissn") != null) {
							journal.setIssnLinking(attr.get("lissn"));
						}
					}
					metadata.setJournal(journal.build());
				}
			}

			final Instance.Builder instance = Instance.newBuilder().setHostedby(getKV(hostedbyId, hostedbyName));

			addField(instance, Instance.getDescriptor().findFieldByName("licence"),
					setQualifier(getDefaultQualifier("dnet:access_modes"), values.get("accessrights").listValues(), "UNKNOWN", "UNKNOWN").build());
			addField(instance, Instance.getDescriptor().findFieldByName("instancetype"),
					setQualifier(getDefaultQualifier("dnet:publication_resource"), values.get("cobjcategory").listValues(), "0000", "Unknown").build());

			if (values.get("identifier") != null) {
				addField(instance, Instance.getDescriptor().findFieldByName("url"),
						Lists.newArrayList(Iterables.filter(values.get("identifier").listValues(), urlFilter)));
			}
			result.addInstance(instance);

			List<Element> extrefs = values.get("reference");
			if (!extrefs.isEmpty()) {
				Descriptor extDesc = ExternalReference.getDescriptor();
				for (Element element : extrefs) {
					ExternalReference.Builder extref = ExternalReference.newBuilder();
					addField(extref, extDesc.findFieldByName("url"), element.getText());
					addField(extref, extDesc.findFieldByName("sitename"), element.getAttributes().get("source"));
					addField(extref, extDesc.findFieldByName("refidentifier"), element.getAttributes().get("identifier"));
					addField(extref, extDesc.findFieldByName("label"), element.getAttributes().get("title"));
					addField(
							extref,
							extDesc.findFieldByName("qualifier"),
							setQualifier(getDefaultQualifier("dnet:externalReference_typologies"),
									Lists.newArrayList(element.getAttributes().get("type")), "UNKNOWN", "UNKNOWN").build());

					result.addExternalReference(extref);
				}
			}

			OafEntity.Builder entity = getEntity(Type.result, resultId, getKV(collectedFromId, collectedFromName), originalId, dateOfCollection,
					parsePids(nodelist)).setResult(result.setMetadata(metadata));

			Oaf oaf = getOaf(entity, getDataInfo(provenanceAction, trust, false, false));
			return base64(oaf.toByteArray());
		} catch (Exception e) {
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}

}