package eu.dnetlib.data.transform.xml;

import java.util.Map;

import org.apache.commons.lang.StringUtils;

import com.google.common.collect.Maps;

public class Element {
	private String text;
	private Map<String, String> attributes;
	
	public Element(String text, Map<String, String> attributes) {
		this.text = text;
		this.attributes = attributes;
	}
	public Element(String text) {
		this.text = text;
		this.attributes = Maps.newHashMap();
	}
	public Element() {
		this.text = "";
		this.attributes = Maps.newHashMap();
	}
	public String getText() {
		return text;
	}
	public void setText(String text) {
		this.text = text;
	}
	public Map<String, String> getAttributes() {
		return attributes;
	}
	public void setAttributes(Map<String, String> attributes) {
		this.attributes = attributes;
	}
	@Override
	public String toString() {
		return "{ " + StringUtils.left(text, 20) + attributes.toString() + " }";
	}
}
