package eu.dnetlib.data.transform;

import com.google.protobuf.InvalidProtocolBufferException;

import eu.dnetlib.data.proto.OafProtos.Oaf;

public class Column<N, V> {

	private N name;

	private V value;

	public Column(final N name, final V value) {
		this.name = name;
		this.value = value;
	}

	public N getName() {
		return name;
	}

	public V getValue() {
		return value;
	}

	@Override
	public String toString() {
		try {
			return "\n\t\t'" + name.toString() + "' : '" + Oaf.parseFrom((byte[]) value) + "'";
		} catch (InvalidProtocolBufferException e) {
			throw new IllegalArgumentException(e);
		}
	}

}
