package eu.dnetlib.data.transform.xml;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.google.protobuf.Descriptors.FieldDescriptor;
import com.google.protobuf.Message.Builder;

import eu.dnetlib.data.proto.DataInfoProtos.DataInfo;
import eu.dnetlib.data.proto.DatasourceOrganizationProtos.DatasourceOrganization;
import eu.dnetlib.data.proto.DatasourceProtos.Datasource;
import eu.dnetlib.data.proto.KeyValueProtos.KeyValue;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.OafProtos.OafRel;
import eu.dnetlib.data.proto.OrganizationProtos.Organization;
import eu.dnetlib.data.proto.PersonProtos.Person;
import eu.dnetlib.data.proto.PersonResultProtos.PersonResult;
import eu.dnetlib.data.proto.ProjectContactpersonProtos.ProjectContactperson;
import eu.dnetlib.data.proto.ProjectOrganizationProtos.ProjectOrganization;
import eu.dnetlib.data.proto.ProjectProtos.Project;
import eu.dnetlib.data.proto.RelTypeProtos.RelType;
import eu.dnetlib.data.proto.ResultOrganizationProtos.ResultOrganization;
import eu.dnetlib.data.proto.ResultProjectProtos.ResultProject;
import eu.dnetlib.data.proto.ResultProtos.Result;
import eu.dnetlib.data.proto.ResultProtos.Result.Instance;
import eu.dnetlib.data.proto.TypeProtos.Type;

public class DNetDbToHbaseXsltFunctions extends AbstractDNetOafXsltFunctions {

	public static String oafEntity(
			final String type,
			final String id,
			final String collectedFromId,
			final String collectedFromName,
			final String originalId,
			final String dateOfCollection,
			final NodeList nodeList) {

		switch (Type.valueOf(type)) {
		case datasource:
			return serializeOafEntity(nodeList, Type.datasource, id, getKV(collectedFromId, collectedFromName), originalId, dateOfCollection,
					Datasource.newBuilder());
		case organization:
			return serializeOafEntity(nodeList, Type.organization, id, getKV(collectedFromId, collectedFromName), originalId, dateOfCollection,
					Organization.newBuilder());
		case person:
			return serializeOafEntity(nodeList, Type.person, id, getKV(collectedFromId, collectedFromName), originalId, dateOfCollection,
					Person.newBuilder());
		case project:
			return serializeOafEntity(nodeList, Type.project, id, getKV(collectedFromId, collectedFromName), originalId, dateOfCollection,
					Project.newBuilder());
		case result:
			return serializeOafEntity(nodeList, Type.result, id, getKV(collectedFromId, collectedFromName), originalId, dateOfCollection,
					Result.newBuilder());
		default:
			throw new IllegalArgumentException("Invalid entity type: " + type);
		}
	}

	public static String oafRel(String relTye, final String source, final String target, final NodeList nodeList) {
		switch (RelType.valueOf(relTye)) {
		case datasourceOrganization:
			return serializeOafRel(nodeList, source, target, RelType.datasourceOrganization, false, DatasourceOrganization.newBuilder());
		case personResult:
			return serializeOafRel(nodeList, source, target, RelType.personResult, false, PersonResult.newBuilder());
		case projectContactperson:
			return serializeOafRel(nodeList, source, target, RelType.projectContactperson, false, ProjectContactperson.newBuilder());
		case projectOrganization:
			return serializeOafRel(nodeList, source, target, RelType.projectOrganization, false, ProjectOrganization.newBuilder());
		case resultOrganization:
			return serializeOafRel(nodeList, source, target, RelType.resultOrganization, false, ResultOrganization.newBuilder());
		case resultProject:
			return serializeOafRel(nodeList, source, target, RelType.resultProject, false, ResultProject.newBuilder());
		default:
			throw new IllegalArgumentException("invalid relType: " + relTye);
		}
	}

	//////////////////////////////////////////////////////////

	protected static String serializeOafEntity(
			final NodeList nodelist,
			final Type type,
			final String id,
			final KeyValue collectedFrom,
			final String originalId,
			final String dateOfCollection,
			final Builder entity) {
		try {
			final FieldDescriptor md = entity.getDescriptorForType().findFieldByName("metadata");

			final OafEntity.Builder parent = getEntity(type, id, collectedFrom, originalId, dateOfCollection, null);
			final Builder metadata = entity.newBuilderForField(md);
			final DataInfo.Builder dataInfo = DataInfo.newBuilder();

			if (type.equals(Type.result)) {
				final Instance.Builder instance = Instance.newBuilder();
				parseNodelist(nodelist, instance);
				FieldDescriptor instanceDescriptor = Result.getDescriptor().findFieldByName(Instance.getDescriptor().getName());
				if (instanceDescriptor != null) {
					entity.setField(instanceDescriptor, instance);
				}
			}
			parseNodelist(nodelist, parent, entity, metadata, dataInfo);

			final FieldDescriptor entityDescriptor = OafEntity.getDescriptor().findFieldByName(type.toString());

			final Oaf build = getOaf(parent.setField(entityDescriptor, entity.setField(md, metadata.build()).build()), dataInfo);

			return base64(build.toByteArray());
		} catch (Exception e) {
			e.printStackTrace(System.err);
			throw new RuntimeException(e);
		}
	}

	protected static String serializeOafRel(
			final NodeList nodeList,
			final String sourceId,
			final String targetId,
			final RelType relType,
			final boolean isChild,
			final Builder rel) {
		try {

			FieldDescriptor metadataDescriptor = rel.getDescriptorForType().findFieldByName("relMetadata");

			final Builder metadata = rel.newBuilderForField(metadataDescriptor);
			final DataInfo.Builder dataInfo = DataInfo.newBuilder();

			parseNodelist(nodeList, rel, metadata, dataInfo);

			FieldDescriptor relDescriptor = OafRel.getDescriptor().findFieldByName(relType.toString());
			Oaf build = getOaf(
					getRel(sourceId, targetId, relType, isChild).setField(relDescriptor, rel.setField(metadataDescriptor, metadata.build()).build()),
					dataInfo);
			return base64(build.toByteArray());
		} catch (Exception e) {
			e.printStackTrace(System.err);
			throw new RuntimeException(e);
		}
	}

	private static void parseNodelist(final NodeList nodeList, final Builder... builders) {

		for (int i = 0; i < nodeList.getLength(); i++) {

			final Node fieldNode = nodeList.item(i);
			final Node attr = fieldNode.getAttributes().getNamedItem("name");

			final String fieldName = attr.getNodeValue();
			final NodeList chilidren = fieldNode.getChildNodes();

			for (int j = 0; j < chilidren.getLength(); j++) {

				final Node child = chilidren.item(j);
				final String childName = child.getLocalName();
				if ("ITEM".equals(childName) || childName.isEmpty()) {
					for (Builder builder : builders) {
						addField(builder, fieldNode, child, childName, builder.getDescriptorForType().findFieldByName(fieldName));
					}
				}
			}
		}
	}

	private static void addField(final Builder builder, final Node fieldNode, final Node child, final String childName, final FieldDescriptor descriptor) {

		if (descriptor != null) {
			String text = getText(childName.isEmpty() ? fieldNode : child);
			addField(builder, descriptor, text);
		}
	}

	private static String getText(Node node) {
		StringBuffer result = new StringBuffer();
		if (!node.hasChildNodes()) {
			return "";
		}

		NodeList list = node.getChildNodes();
		for (int i = 0; i < list.getLength(); i++) {
			Node subnode = list.item(i);
			if (subnode.getNodeType() == Node.TEXT_NODE) {
				result.append(subnode.getNodeValue());
			} else if (subnode.getNodeType() == Node.CDATA_SECTION_NODE) {
				result.append(subnode.getNodeValue());
			} else if (subnode.getNodeType() == Node.ENTITY_REFERENCE_NODE) {
				result.append(getText(subnode));
			}
		}
		return result.toString().trim();
	}

}
