/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.PersonPersonProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.PersonResultProtos;
import eu.dnetlib.data.proto.RelMetadataProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultProjectProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetOafXsltFunctions;
import eu.dnetlib.data.transform.xml.Element;
import eu.dnetlib.data.transform.xml.ElementList;
import eu.dnetlib.data.transform.xml.ValueMap;
import eu.dnetlib.pace.model.Person;
import java.util.ArrayList;
import java.util.Map;
import org.w3c.dom.NodeList;

public class DmfToHbaseXsltFunctions
extends AbstractDNetOafXsltFunctions {
    public static String oafPersonResultFromDMF(String personId, String resultId, int rank, String provenanceAction, String trust) {
        try {
            PersonResultProtos.PersonResult.Builder pr = PersonResultProtos.PersonResult.newBuilder().setRanking("" + rank);
            RelMetadataProtos.RelMetadata.Builder metadata = RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DmfToHbaseXsltFunctions.getSimpleQualifier("author", "dnet:personroles"));
            OafProtos.OafRel.Builder rel = DmfToHbaseXsltFunctions.getRel(personId, resultId, RelTypeProtos.RelType.personResult, false).setPersonResult(pr.setRelMetadata(metadata));
            return DmfToHbaseXsltFunctions.base64(DmfToHbaseXsltFunctions.getOaf(rel, DmfToHbaseXsltFunctions.getDataInfo(provenanceAction, trust, false, false)).toByteArray());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static String oafPersonPersonFromDMF(String source, String target, String provenanceAction, String trust) {
        try {
            PersonPersonProtos.PersonPerson.Builder pp = PersonPersonProtos.PersonPerson.newBuilder();
            RelMetadataProtos.RelMetadata.Builder metadata = RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DmfToHbaseXsltFunctions.getSimpleQualifier("coauthor", "dnet:personroles"));
            OafProtos.OafRel.Builder rel = DmfToHbaseXsltFunctions.getRel(source, target, RelTypeProtos.RelType.personPerson, false).setPersonPerson(pp.setRelMetadata(metadata));
            return DmfToHbaseXsltFunctions.base64(DmfToHbaseXsltFunctions.getOaf(rel, DmfToHbaseXsltFunctions.getDataInfo(provenanceAction, trust, false, false)).toByteArray());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static String oafPersonFromDMF(String personId, String fullname, String provenanceAction, String trust, String collectedFromId, String collectedFromName, String originalId, String dateOfCollection) {
        try {
            PersonProtos.Person.Builder person = PersonProtos.Person.newBuilder();
            PersonProtos.Person.Metadata.Builder metadata = PersonProtos.Person.Metadata.newBuilder();
            metadata.setFullname(fullname);
            Person p = new Person(fullname, false);
            if (p.isAccurate()) {
                metadata.setFirstname(p.getNormalisedFirstName());
                metadata.clearSecondnames().addSecondnames(p.getNormalisedSurname());
                metadata.setFullname(p.getNormalisedFullname());
            }
            ArrayList pids = Lists.newArrayList();
            OafProtos.OafEntity.Builder entity = DmfToHbaseXsltFunctions.getEntity(TypeProtos.Type.person, personId, DmfToHbaseXsltFunctions.getKV(collectedFromId, collectedFromName), originalId, dateOfCollection, pids).setPerson(person.setMetadata(metadata));
            return DmfToHbaseXsltFunctions.base64(DmfToHbaseXsltFunctions.getOaf(entity, DmfToHbaseXsltFunctions.getDataInfo(provenanceAction, trust, false, false)).toByteArray());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static String oafResultProjectFromDMF(String sourceId, String targetId, String provenanceAction, String trust) {
        try {
            ResultProjectProtos.ResultProject.Builder rp = ResultProjectProtos.ResultProject.newBuilder();
            RelMetadataProtos.RelMetadata.Builder metadata = RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DmfToHbaseXsltFunctions.getSimpleQualifier("isResultOf", "dnet:result_project_relations"));
            OafProtos.OafRel.Builder rel = DmfToHbaseXsltFunctions.getRel(sourceId, targetId, RelTypeProtos.RelType.resultProject, false).setResultProject(rp.setRelMetadata(metadata));
            return DmfToHbaseXsltFunctions.base64(DmfToHbaseXsltFunctions.getOaf(rel, DmfToHbaseXsltFunctions.getDataInfo(provenanceAction, trust, false, false)).toByteArray());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static String oafResultFromDMF(String resultId, String provenanceAction, String trust, String hostedbyId, String hostedbyName, String collectedFromId, String collectedFromName, String originalId, String dateOfCollection, NodeList nodelist) {
        try {
            ResultProtos.Result.Builder result = ResultProtos.Result.newBuilder();
            ValueMap values = DmfToHbaseXsltFunctions.parseNodeList(nodelist);
            ResultProtos.Result.Metadata.Builder metadata = ResultProtos.Result.Metadata.newBuilder();
            Descriptors.Descriptor mDesc = ResultProtos.Result.Metadata.getDescriptor();
            DmfToHbaseXsltFunctions.addStructuredProps((Message.Builder)metadata, mDesc.findFieldByName("subject"), values.get("subject").listValues(), "keyword", "dnet:result_subject");
            DmfToHbaseXsltFunctions.addStructuredProps((Message.Builder)metadata, mDesc.findFieldByName("title"), values.get("title").listValues(), "main title", "dnet:dataCite_title");
            for (String fieldname : Lists.newArrayList((Object[])new String[]{"description", "source"})) {
                if (values.get(fieldname) == null) continue;
                for (String s : values.get(fieldname).listValues()) {
                    DmfToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName(fieldname), s);
                }
            }
            DmfToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("language"), DmfToHbaseXsltFunctions.setQualifier(DmfToHbaseXsltFunctions.getDefaultQualifier("dnet:languages"), values.get("language").listValues(), "und", "Undetermined").build());
            DmfToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("dateofacceptance"), values.get("dateaccepted").listValues());
            DmfToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("publisher"), values.get("publisher").listValues());
            DmfToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("embargoenddate"), values.get("embargoenddate").listValues());
            DmfToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("storagedate"), values.get("storagedate").listValues());
            DmfToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("resulttype"), DmfToHbaseXsltFunctions.getSimpleQualifier("publication", "dnet:result_typologies").build());
            DmfToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("fulltext"), values.get("fulltext").listValues());
            if (values.get("journal") != null) {
                for (Element e : values.get("journal")) {
                    Map<String, String> attr;
                    ResultProtos.Result.Journal.Builder journal = ResultProtos.Result.Journal.newBuilder();
                    if (e.getText() != null) {
                        journal.setName(e.getText());
                    }
                    if ((attr = e.getAttributes()) != null) {
                        if (attr.get("issn") != null) {
                            journal.setIssnPrinted(attr.get("issn"));
                        }
                        if (attr.get("eissn") != null) {
                            journal.setIssnOnline(attr.get("eissn"));
                        }
                        if (attr.get("lissn") != null) {
                            journal.setIssnLinking(attr.get("lissn"));
                        }
                    }
                    metadata.setJournal(journal.build());
                }
            }
            ResultProtos.Result.Instance.Builder instance = ResultProtos.Result.Instance.newBuilder().setHostedby(DmfToHbaseXsltFunctions.getKV(hostedbyId, hostedbyName));
            DmfToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("licence"), DmfToHbaseXsltFunctions.setQualifier(DmfToHbaseXsltFunctions.getDefaultQualifier("dnet:access_modes"), values.get("accessrights").listValues(), "UNKNOWN", "UNKNOWN").build());
            DmfToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("instancetype"), DmfToHbaseXsltFunctions.setQualifier(DmfToHbaseXsltFunctions.getDefaultQualifier("dnet:publication_resource"), values.get("cobjcategory").listValues(), "0000", "Unknown").build());
            if (values.get("identifier") != null) {
                DmfToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("url"), Lists.newArrayList((Iterable)Iterables.filter(values.get("identifier").listValues(), (Predicate)urlFilter)));
            }
            result.addInstance(instance);
            ElementList extrefs = values.get("reference");
            if (!extrefs.isEmpty()) {
                Descriptors.Descriptor extDesc = ResultProtos.Result.ExternalReference.getDescriptor();
                for (Element element : extrefs) {
                    ResultProtos.Result.ExternalReference.Builder extref = ResultProtos.Result.ExternalReference.newBuilder();
                    DmfToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("url"), element.getText());
                    DmfToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("sitename"), element.getAttributes().get("source"));
                    DmfToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("refidentifier"), element.getAttributes().get("identifier"));
                    DmfToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("label"), element.getAttributes().get("title"));
                    DmfToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("qualifier"), DmfToHbaseXsltFunctions.setQualifier(DmfToHbaseXsltFunctions.getDefaultQualifier("dnet:externalReference_typologies"), Lists.newArrayList((Object[])new String[]{element.getAttributes().get("type")}), "UNKNOWN", "UNKNOWN").build());
                    result.addExternalReference(extref);
                }
            }
            OafProtos.OafEntity.Builder entity = DmfToHbaseXsltFunctions.getEntity(TypeProtos.Type.result, resultId, DmfToHbaseXsltFunctions.getKV(collectedFromId, collectedFromName), originalId, dateOfCollection, DmfToHbaseXsltFunctions.parsePids(nodelist)).setResult(result.setMetadata(metadata));
            OafProtos.Oaf oaf = DmfToHbaseXsltFunctions.getOaf(entity, DmfToHbaseXsltFunctions.getDataInfo(provenanceAction, trust, false, false));
            return DmfToHbaseXsltFunctions.base64(oaf.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

