package eu.dnetlib.data.mapreduce.util;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;

import eu.dnetlib.data.proto.KindProtos.Kind;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.OafProtos.OafRel;
import eu.dnetlib.data.proto.RelTypeProtos.RelType;

/**
 * Helper class, to be used as accessor helper over the Oaf structure.
 * 
 * @author claudio
 * 
 */
public class OafDecoder {

	/**
	 * Oaf object
	 */
	private Oaf oaf;

	/**
	 * Cached sub decoder
	 */
	private OafEntityDecoder entityDecoder = null;

	/**
	 * Cached sub decoder
	 */
	private OafRelDecoder relDecoder = null;

	public static OafDecoder decode(final Oaf oaf) {
		return new OafDecoder(oaf);
	}

	public static OafDecoder decode(final byte[] oaf) {
		return new OafDecoder(oaf);
	}

	protected OafDecoder(final byte[] value) {
		try {
			this.oaf = Oaf.parseFrom(value);
		} catch (InvalidProtocolBufferException e) {
			throw new RuntimeException("unable to deserialize proto: " + new String(value));
		}
	}

	private OafDecoder(final Oaf oaf) {
		this.oaf = oaf;
	}

	public Kind getKind() {
		return oaf.getKind();
	}

	public Oaf getOaf() {
		return oaf;
	}

	// / Entity

	public GeneratedMessage getMetadata() {
		return decodeEntity().getMetadata();
	}

	public GeneratedMessage getOafEntity() {
		return decodeEntity().getEntity();
	}

	public String getEntityId() {
		return decodeEntity().getId();
	}

	public OafEntity getEntity() {
		return oaf.getEntity();
	}

	public OafEntityDecoder decodeEntity() {
		if (entityDecoder == null) {
			entityDecoder = OafEntityDecoder.decode(getEntity());
		}
		return entityDecoder;
	}

	// / Rel

	public OafRel getOafRel() {
		return oaf.getRel();
	}

	public GeneratedMessage getRel() {
		return decodeRel().getRel();
	}

	public RelType relType() {
		return decodeRel().getRelType();
	}

	public String relTypeName() {
		return relType().toString();
	}

	public String relSourceId() {
		return decodeRel().getRelSourceId();
	}

	public String relTargetId() {
		return decodeRel().getRelTargetId();
	}

	private OafRelDecoder decodeRel() {
		if (relDecoder == null) {
			relDecoder = OafRelDecoder.decode(getOafRel());
		}
		return relDecoder;
	}

	public byte[] toByteArray() {
		return oaf.toByteArray();
	}

}
