package eu.dnetlib.functionality.modular.examples;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.ProgressProvider;

public class HelloNode extends SimpleJobNode implements ProgressJobNode {

	private int ntimes = 1;
	private String helloName = "world";
	private int sleepSeconds = 1;

	private int counter = 1;

	@Override
	public String execute(final NodeToken token) {

		while (counter <= ntimes) {
			System.out.println(" --- " + counter + ") Hello " + helloName + "!");
			try {
				Thread.sleep(sleepSeconds * 1000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			counter++;
		}

		return Arc.DEFAULT_ARC;
	}

	public int getNtimes() {
		return ntimes;
	}

	public void setNtimes(final int ntimes) {
		this.ntimes = ntimes;
	}

	public String getHelloName() {
		return helloName;
	}

	public void setHelloName(final String helloName) {
		this.helloName = helloName;
	}

	public int getSleepSeconds() {
		return sleepSeconds;
	}

	public void setSleepSeconds(final int sleepSeconds) {
		this.sleepSeconds = sleepSeconds;
	}

	@Override
	public ProgressProvider getProgressProvider() {
		return new ProgressProvider() {

			@Override
			public boolean isInaccurate() {
				return false;
			}

			@Override
			public int getTotalValue() {
				return ntimes;
			}

			@Override
			public int getCurrentValue() {
				return counter;
			}
		};
	}

}
