/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.collapsers;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Reducer;

public class DefaultCollapserReducer
extends Reducer<AvroKey<String>, AvroValue<IndexedRecord>, AvroKey<IndexedRecord>, NullWritable> {
    private List<String> origins;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.origins = Arrays.asList(context.getConfiguration().get("origins").split(","));
    }

    public void reduce(AvroKey<String> key, Iterable<AvroValue<IndexedRecord>> values, Reducer.Context context) throws IOException, InterruptedException {
        IndexedRecord bestRecord = null;
        for (AvroValue<IndexedRecord> value : values) {
            if (bestRecord == null) {
                bestRecord = (IndexedRecord)GenericData.get().deepCopy(((IndexedRecord)value.datum()).getSchema(), value.datum());
            }
            int bestPos = bestRecord.getSchema().getField("origin").pos();
            int valuePos = ((IndexedRecord)value.datum()).getSchema().getField("origin").pos();
            String bestOrigin = (String)bestRecord.get(bestPos);
            String valueOrigin = (String)((IndexedRecord)value.datum()).get(valuePos);
            if (this.origins.indexOf(bestOrigin) <= this.origins.indexOf(valueOrigin)) continue;
            bestRecord = (IndexedRecord)GenericData.get().deepCopy(((IndexedRecord)value.datum()).getSchema(), value.datum());
        }
        int dataPos = bestRecord.getSchema().getField("data").pos();
        context.write((Object)new AvroKey((Object)((IndexedRecord)bestRecord.get(dataPos))), (Object)NullWritable.get());
    }
}

