/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.collapsers;

import eu.dnetlib.iis.collapsers.schemas.DocumentTextEnvelope;
import eu.dnetlib.iis.metadataextraction.schemas.DocumentText;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Reducer;

public class DocumentTextReducer
extends Reducer<AvroKey<String>, AvroValue<DocumentTextEnvelope>, AvroKey<DocumentText>, NullWritable> {
    private List<String> origins;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.origins = Arrays.asList(context.getConfiguration().get("origins").split(","));
    }

    public void reduce(AvroKey<String> key, Iterable<AvroValue<DocumentTextEnvelope>> values, Reducer.Context context) throws IOException, InterruptedException {
        CharSequence[] texts = new CharSequence[this.origins.size()];
        for (AvroValue<DocumentTextEnvelope> value : values) {
            texts[this.origins.indexOf((Object)((DocumentTextEnvelope)value.datum()).getOrigin())] = ((DocumentTextEnvelope)value.datum()).getData().getText();
        }
        StringBuilder sb = new StringBuilder();
        for (CharSequence text : texts) {
            if (text == null) continue;
            sb.append(text);
            sb.append("\n");
        }
        DocumentText text = DocumentText.newBuilder().setId((CharSequence)key.datum()).setText((CharSequence)sb.toString().trim()).build();
        context.write((Object)new AvroKey((Object)text), (Object)NullWritable.get());
    }
}

