package eu.dnetlib.iis.collapsers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.logicalLayer.schema.SchemaUtil;

/**
 * @author Dominika Tkaczyk
 */
public class IdReplacerUDF extends EvalFunc<Tuple> {

    @Override
    /** Mafju review: a docstring that describes what are the elements of the 
     * accepted tuple would be nice
     */
    public Tuple exec(Tuple tuple) throws IOException {
        if (tuple.get(2) != null) {
        	/** Mafju review: esthetics remark: this whole code that traverses 
        	 * the schema tree and returns appropriate tuple and position should
        	 * be extracted and put in a separate method named, e.g. 
        	 * "getIdField".
        	 */
            String[] ids = ((String)tuple.get(0)).split("\\.");
            Schema actSchema = getInputSchema();
            Tuple actTuple = tuple;
            for (int i = 0; i < ids.length - 1; i++) {
                int pos = actSchema.getPosition(ids[i]);
                actSchema = actSchema.getField(ids[i]).schema;
                /** Mafju review: here, there should be "actTuple" instead of
                 * "tuple" right? */
                actTuple = (Tuple) tuple.get(pos);
            }
            
            int pos = actSchema.getPosition(ids[ids.length-1]);
            actTuple.set(pos, tuple.get(2));
        }

        TupleFactory tupleFactory = TupleFactory.getInstance();
        List<Object> tuples = new ArrayList<Object>();
        for (int i = 3; i < tuple.size(); i++) {
            tuples.add(tuple.get(i));
        }
        
        return tupleFactory.newTuple(tuples);
    }

    

    @Override
    public Schema outputSchema(Schema input) {
        try {
            List<Byte> types = new ArrayList<Byte>();
            for (int i = 3; i < input.size(); i++) {
                types.add(input.getField(i).type);
            }
            return SchemaUtil.newTupleSchema(types);
        } catch (FrontendException ex) {
            return null;
        }
    }
    
}
