/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.collapsers;

import eu.dnetlib.iis.core.common.AvroUtils;
import eu.dnetlib.iis.core.java.HadoopContext;
import eu.dnetlib.iis.core.java.PortBindings;
import eu.dnetlib.iis.core.java.Process;
import eu.dnetlib.iis.core.java.io.CloseableIterator;
import eu.dnetlib.iis.core.java.io.DataStore;
import eu.dnetlib.iis.core.java.io.FileSystemPath;
import eu.dnetlib.iis.core.java.porttype.AvroPortType;
import eu.dnetlib.iis.core.java.porttype.PortType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class Union
implements Process {
    private static final String outputPort = "output";
    private Schema inputSchema;
    private Schema outputSchema;

    public Map<String, PortType> getInputPorts() {
        return new HashMap<String, PortType>();
    }

    public Map<String, PortType> getOutputPorts() {
        HashMap<String, PortType> outputPorts = new HashMap<String, PortType>();
        outputPorts.put(outputPort, (PortType)new AvroPortType(this.outputSchema));
        return outputPorts;
    }

    public void run(PortBindings portBindings, HadoopContext context, Map<String, String> parameters) throws Exception {
        if (parameters.get("origins") == null) {
            throw new RuntimeException("No origins parameter passed!");
        }
        if (parameters.get("input_ports") == null) {
            throw new RuntimeException("No input_ports parameter passed!");
        }
        if (parameters.get("input_schema") == null) {
            throw new RuntimeException("No input_schema parameter passed!");
        }
        if (parameters.get("output_schema") == null) {
            throw new RuntimeException("No output_schema parameter passed!");
        }
        List<String> origins = Arrays.asList(parameters.get("origins").split(","));
        List<String> inputPorts = Arrays.asList(parameters.get("input_ports").split(","));
        this.inputSchema = AvroUtils.toSchema((String)parameters.get("input_schema"));
        this.outputSchema = AvroUtils.toSchema((String)parameters.get("output_schema"));
        List fields = this.outputSchema.getFields();
        if (fields.size() != 2 || !"origin".equals(((Schema.Field)fields.get(0)).name()) && !"origin".equals(((Schema.Field)fields.get(1)).name())) {
            throw new RuntimeException("Output schema: " + this.outputSchema + " should contain two fields, one of them named \"origin\"!");
        }
        Schema.Field dataField = (Schema.Field)fields.get(0);
        if ("origin".equals(((Schema.Field)fields.get(0)).name())) {
            dataField = (Schema.Field)fields.get(1);
        }
        if (!this.inputSchema.equals((Object)dataField.schema())) {
            throw new RuntimeException("Schemas: " + this.inputSchema + " and " + dataField.schema() + " are not the same!");
        }
        FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
        DataFileWriter output = DataStore.create((FileSystemPath)new FileSystemPath(fs, (Path)portBindings.getOutput().get(outputPort)), (Schema)this.outputSchema);
        int index = 0;
        for (String inputPort : inputPorts) {
            String origin = origins.get(index++);
            CloseableIterator it = DataStore.getReader((FileSystemPath)new FileSystemPath(fs, new Path(inputPort)), (Schema)this.inputSchema);
            while (it.hasNext()) {
                GenericData.Record outputRecord = new GenericData.Record(this.outputSchema);
                outputRecord.put("origin", (Object)origin);
                outputRecord.put(dataField.name(), it.next());
                output.append((Object)outputRecord);
            }
        }
        output.close();
    }
}

